/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/************************************************************************
**                 
**                           main.c
**
**      This file contains the main program for the SGMPASK daemon.
** Usage:
**       sgmpask[options] config_file
**
***********************************************************************/

#include "sgmp.h"                  /* general include */
#include "sgmpask.h"               /* application specific include */

#define	INITFILE	"/etc/sgmp.variables"

main(argc,argv)
int argc;
char *argv[];

{
int sgmpask_errlog;                   /* error log file descriptor */
int config_file;                      /* pointer to the configuration file */
int i;                                /* a humble counter */
int req_id;                           /* the request id */
int session_len;                      /* length of the session_id */
int fd;                               /* file descriptor for tty */
int var_count;                        /* the total number of variables */
int pid;                              /* the process id */
int how_many;                         /* the number of times to be queried*/
long clock;                           /* the time */
short var_size;                       /* the size of the variable */
struct itimerval *value,*ovalue;        /* for using setitimer system call */
strng *struc_strng,*mem;                /* for char and it's size */
get_req_msg_type *mesg;               /* ptr. to the message to be sent */
var_op_list_type   temp,p;            /* ptr. to the variable in mesg.  */
strng *sgmp_var_cvt();                     /* the converter function */
void intr_handler_main() ;            /* for handling the timeout */
extern int reaper();                  /* to reap dead children */
extern int readconfig();              /* read the configuration  file */

/* check command line for configuration file */

if(argc < 2) {                     /* is the configuration file given ? */
 fprintf(stderr,"Insufficient number of arguments specified\n");
 fprintf(stderr,"usage : sgmpask [options] configuration_file\n");
exit(1); 
}
/* redirect stderr */

if((sgmpask_errlog = open(ERRLOG,(O_CREAT | O_RDWR),0660)) < 0){/*get descrip.*/
  fprintf(stderr,"Could not open an error log, exiting ...\n");
    exit(0);}

if (dup2(sgmpask_errlog,2) < 0) {     /* duplicate descriptor */
  fprintf(stderr, "Could not duplicate descriptor,exiting ... \n");
   exit(0); }
close(sgmpask_errlog);                /* not needed anymore, so close it */


 
/* Open the configuration file for reading */
if((config_file = open(argv[argc - 1],O_RDONLY,0)) < 0){
 fprintf(stderr,"Cannot open the configuration file :: %s \n",argv[argc-1]);
exit(1);
}

/* switch the standard input */
if(dup2(config_file,0) < 0) {
 fprintf(stderr,"Unable to redirect standard input, bye! ...\n");
exit(1);
}
close(config_file);                 /* not needed anymore */

/* Read the options and process them */
for(i = 1; i < (argc - 3);i++)      /* iterate through the options */
  { if(argv[i][0] != '-')           /* is it an option? */
      { fprintf(" Unrecognizable option, %s\n",argv[i]);
         exit(1);
      }
 switch(argv[i][1]) {               /* determine the options */
 
/* NO options as yet, sometime in the future .... */

 default:
  fprintf(stderr,"Illegal option %s\n",argv[i]);
  fprintf(stderr,"usage : sgmpask [options] configuration_file &\n");
 exit(1);
}
  }

/* prepare for the signals */
#ifdef hpux
signal(SIGCLD, SIG_IGN);
#else
signal(SIGCHLD,reaper);           /* In case we fork */
#endif

/* read the config file */
  readconfig();

if((mesg = (get_req_msg_type *)malloc(sizeof(get_req_msg_type))) == NULL)
  { fprintf(stderr," Could not allocate memory in main.c, exiting...");
    exit(1);
  }
/*construct the packet to be sent */
                                 /* compute the request id */
 pid = getpid();                          /* get the process id */
  time(&clock);                           /* get the time */
 req_id = mesg->request_id = pid ^ (int)ctime(&clock);  /* request id */
 mesg->error_status = 0;                  /*initialize */
 mesg->error_index = 0;                   /*initialize */
                                 /*construct the variable list */
var_count = *smpask_count;                /* no. of var. in config. file */
if((mesg->var_op_list = (var_op_type *)malloc(sizeof( var_op_type))) == NULL)
  { fprintf(stderr,"Cannot allocate memory in SGMPASK main.c\nexiting...\n");
     exit(1);
  }
p = mesg->var_op_list;
if(sgmp_init_cvt(INITFILE) < 0)    /* initialize the converter */
  {fprintf(stderr,"SGMPASK :: sgmp_init_cvt : Error while initializing the convertor\n");
       exit(1);
 }

for(i = 0;i < *smpask_count;i++)        /* create the message to be sent */
 {

p->var_value.type = INTEGER;            /* dummy allocation */
p->var_value.value.intgr = 1;           /* dummy allocation */


                                 /* memory space for the strng structure */
if((struc_strng = (strng*)malloc(sizeof(strng))) == NULL)  
{ fprintf(stderr,"Could not allocate memory in SGMPASK main.c\nexiting...");
  exit(1);
}
p->var_name = struc_strng;
var_size = strlen((*smpask_file_var)[i].variable_name); /* size of variable */
                                 /* memory for strng->str */
if((struc_strng->str = (char *)malloc(var_size+1)) == NULL)
{ fprintf(stderr,"Could not allocate memory in SGMPASK main.c\nexiting...");
  exit(1);
}
                                 /* fill in the variable and its size */
struc_strng->str = (*smpask_file_var)[i].variable_name;
struc_strng->len = var_size;
p->var_name = sgmp_var_cvt(struc_strng,SYMTONUM); /* call the convertor */
 
 if(i < (*smpask_count) - 1)     /* allocate pointer to next variable */
{
 if((temp = (var_op_type*)malloc(sizeof( var_op_type))) == NULL)
 { fprintf(stderr,"Cannot allocate memory in SGMPASK main.c\nexiting...\n");
    exit(1);
  }
 
   p->var_next = temp;
   p = temp;                   /* for the next variable */
  }
}

/* All initializations over, start sending and receiving sgmpask messages */

how_many = *how_many_times;    /* number of times to be queried */

session_len = strlen(s_id);               /* the session id length */

/* All set, start the timer and get ready to count down */
   /* allocate memory for the timers */
 if((value = (struct itimerval *)malloc(sizeof(struct itimerval))) == NULL)
   { fprintf(stderr,"Can't allocate memory in SGMPASK main.c\n");
      exit(1);
   }
if((ovalue = (struct itimerval *)malloc(sizeof(struct itimerval))) == NULL)
   { fprintf(stderr,"Can't allocate memory in SGMPASK main.c\n");
      exit(1);
   }
 
 switch(how_many)
{
 case forever:
       for(;;)
       process_mesg(mesg,req_id,s_id,session_len);


 default:
       for(i= *how_many_times; i > 0; i--)
       process_mesg(mesg,req_id,s_id,session_len);
    
     }


   if((close(sgmp_get_sock(req_id))) < 0)               /* close the socket */
   fprintf(stderr," SGMPASK : Could not close socket\n");
}
