.TH SGMPTRAPD LOCAL "October 1 1987"
.SH NAME
sgmptrapd \- Trap daemon to accept SGMP traps
.SH SYNOPSIS
.B sgmptrapd configfile &
.SH DESCRIPTION
.LP
.I sgmptrapd
is a trap daemon designed to sit and await traps generated via
the 
.I Simple Gateway Monitoring Protocol
directed at the host on which it is running. Which gateways it will
accept traps from, and where it indicates the receipt of a trap
are determined by its configuration file
.I configfile
as described below.
.SH SGMPTRAPD CONFIGURATION FILE
.LP
The
.I sgmptrapd
configuration file is consulted upon initial startup of the daemon.
Based on its contents,
.I sgmptrapd
determines whether or not to accept the trap, and where to indicate
receipt of the trap. Options in the
.I sgmptrapd
configuration file are:
.in +2
.sp
.IP -
SEPLOG \fIgateway_address logname\fR - log all incoming traps from
the gateway with address \fIgateway_address\fR in a separate log
\fIlogname\fR. Multiple occurrences of the SEPLOG option are allowed
within a single configuration file to allow for the logging of traps
from more than one gateway. \fIgateway_address\fR should be a dot
notation IP address such as '128.94.248.254'.
.IP -
NETLOG \fInet logname\fR - log all incoming traps from network \fInet\fR
into log \fIlogname\fR. \fInet\fR should be a dot notation IP address
for a network, such as '128.213.0.0'. Multiple occurrences of
the NETLOG option are allowed within a single configuration file.
.IP -
ALLLOG \fIlogname\fR - log all traps in \fIlogname\fR. This includes the
logging of traps that are also separately logged with the SEPLOG
or NETLOG options. Every configuration file must have one ALLLOG option
specified.
.IP -
SESSION \fIsession_name\fR - accept traps in session \fIsession_name\fR.
This is a required parameter that must occur once in every configuration file.
.in -2
.LP
Currently,
.I sgmptrapd
will only log into UNIX flat files, although an extension of its logging
capabilities is planned.
.SH SGMPTRAPD LOGS
.LP
All incoming traps received by
.I sgmptrapd
are logged into the appropriate log in the format:
.sp
.in +3
\fITime Stamp	Source Address	Trap Type\fR
.in -3
.LP
Any errors encountered while running the application are written into
the errorlog /etc/sgmptrapd.errlog.
.SH FILES
.in +5
/etc/services			To find the 'sgmp' service
.br
\fIlog\fR					For logging traps
.br
/etc/sgmptrapd.errlog	Error log
.SH SEE ALSO
\&"A Simple Gateway Monitoring Protocol", RFC 1028, by J.R. Davin,
J.D. Case, M.S. Fedor and M.L. Schoffstall.
