.TH SGMPROUTE LOCAL "October 1 1987"
.SH NAME
sgmproute \- SGMP application to query for routing information
.SH SYNOPSIS
.B sgmproute [-s session] gateway [net_addr]
.SH DESCRIPTION
.LP
.I sgmproute
is an application written to query a gateway
.I gateway
(specified either as a dot notation address such as '128.84.248.254' or as
a name such as 'csgwd.rpi.edu')
for routing information.
The -s option allows the user to specify a session name to be used
in obtaining routing information. In the event that the -s option
is not used, the session name used will default to 
.I public.
Invoked without the optional 
.I net_addr
argument,
.I sgmproute
will 'walk' the gateway's routing table, returning,
for each net, the following four values:
.in +3
.IP (1)
The next gateway to which traffic is directed by the route identified
by the net address portion of the name of the variable printed out.
This is the value of the '_GW_pr_in_rt_gateway' variable.
.IP (2)
The integer value that represents the metric of the route identified by
the net address portion of the name of the variable printed out.
This is the value of the '_GW_pr_in_rt_metric0' variable.
.IP (3)
The type of route identified by the net address portion of the name of
the variable printed out. This is the value of the '_GW_pr_in_rt_type'
variable.
.IP (4)
How the routing information was learned by the gateway being queried.
This is the value of the '_GW_pr_in_rt_how-learned' variable.
.in -3
.LP
If
.I sgmproute
is invoked with the optional 
.I net_addr 
argument present, only information for the route corresponding to
.I net_addr
is returned.
.SH FILES
.in +5
/etc/sgmp.variables		the variable initfile
.br
/etc/services			to find the 'sgmp' service
.in -5
.SH SEE ALSO
sgmpask(l), sgmplookup(l), sgmpquery(l), sgmpwatch(l), "A Simple Gateway
Monitoring Protocol", RFC 1028, by J.R. Davin, J.D. Case, M.S. Fedor,
M.L. Schoffstall.

