.TH SGMPLOOKUP LOCAL "October 1 1987"
.SH NAME
sgmplookup \- SGMP interactive querying application
.SH SYNOPSIS
.B sgmplookup
[ initfile ]
.SH DESCRIPTION
.LP
.I sgmplookup
is an application to allow the interactive querying of Internet gateways
running the 
.I Simple Gateway Monitoring Protocol.
Invoked without any arguments,
.I sgmplookup
will use a default initialization file,
.I /etc/sgmp.variables
to allow the mapping of symbolic (human-readable) SGMP variables to
their numeric equivalents for the querying of gateways. An optional
variable initialization file in the format of 
.I /etc/sgmp.variables
can be specified on the command line if it is desired that an alternate
variable initialization file be used.
.LP
Once started up,
.I sgmplookup
will prompt the user for commands (see section
.I COMMANDS
below), and act upon the commands issued by the user.
.SH COMMANDS
.IP -
.I ? or help:
print the standard help message, which lists legal commands in
.I sgmplookup.
.IP -
.I gateway gw:
set the gateway for all future queries to the gateway
.I gw
where \fIgw\fR is either a dot notation address (eg: '128.84.248.254')
or a name (eg: 'csgwd.rpi.edu').
This command simply sets an internal variable - it will
not check the validity of \fIgw\fR.
.IP -
.I session session_name:
set the session name for querying to
.I session_name.
.I session name
should be a string of ASCII characters.
.IP -
.I retry maxretries:
set the number of times to retry in the event of a receive failure to
.I maxretries,
where 
.I maxretries 
is an integer quantity.
Note that this is the number of times to retry a receive, not the
number of times to try. In other words, setting the number of
times to retry to 0 will result in only one receive try, setting it to
1 will cause two tries etc.
.IP -
.I timeout seconds:
set the timeout for both send and receive attempts to 
.I seconds
seconds, with
.I seconds 
being an integer quantity. There is no way currently to specify a
separate timeout for send and receive attempts.
.IP -
.I query variable:
query the remote gateway (set by the
.I gateway
command above) for the value of variable
.I variable.
.I sgmplookup 
will print out the name of the variable received, together with the
value of the variable. If the value is an integer, both the
octal and decimal representations of the value will be printed out. If the
value is a character string, that character string will be printed out.
Variables used must be fully qualified here: to query for the value
of the variable '_GW_version_id', it is necessary to specify
the full name, '_GW_version_id; it will not suffice to specify 'version_id' or
simply 'id'.
.IP -
.I mquery variable_class:
query for the values of all instances of the variable class
.I variable_class.
As with the
.I query
command, variable classes such as '_GW_pr_in_rt_gateway' must be
fully specified.
.IP -
.I srcroute IPadd:
find the source of routing information for net
.I IPadd.
.IP -
.I display:
display settings for \fIgateway,session id, maxretries and timeout\fR
.IP -
.I ^D or quit:
leave
.I sgmplookup.
Note that 'q' does not work.
.SH FILES
.in +5
/etc/sgmp.variables		default variable initfile
.br
/etc/services			to find the 'sgmp' service
.in -5
.SH SEE ALSO
sgmpask(l), sgmpquery(l), sgmproute(l), sgmpwatch(l), "A Simple Gateway 
Monitoring Protocol", RFC 1028, by J. R. Davin, J.D. Case, M.S. Fedor and
M.L. Schoffstall.
