.TH SGMPASK LOCAL "October 1 1987"
.SH NAME
sgmpask \- generic SGMP querying application
.SH SYNOPSIS
.B sgmpask configfile initfile
.SH DESCRIPTION
.LP
.I sgmpask
is a generic querying application designed to 'sit' on a host and
query a gateway for information over an extended period of time.
What information is requested, from which gateway, and how often the
information is requested are all dictated by the
.I sgmpask
configuration file 
.I configfile
(described below).
.LP
.I sgmpask
is an application process, started up on a
per-gateway basis
can be more than one
.I sgmpask
process running on any given host at a time). Each
.I sgmpask
invocation is used to query a single gateway, and hence there should
be multiple, separate invocations of 
.I sgmpask
if multiple gateways are to be queried.
.LP
There are some obvious limitations within this model, as each 
monitored gateway will require a separate process, with the 'normal'
UNIX process resource requirements. At this time, it is not possible
to make 'generic' global requests of all gateways, via IP multicast
facilities. Currently, all
.I sgmpask
output is logged to UNIX flat files.
.LP
The 
.I initfile
argument on the command line is intended for the use of a variable
conversion routine within
.I sgmpask.
The format of this file is the same as that of /etc/sgmp.variables,
and indeed the user is encouraged to use /etc/sgmp.variables as
far as possible.
.SH SGMPASK CONFIGURATION FILE
.LP
The 
.I sgmpask
configuration file is consulted upon startup of an
.I sgmpask
process. Fields within this file are used to determine which networks
are to be queried, the values of which variables (on a per-network
basis) are to be requested, and how often the gateway is to be queried.
Options in the configuration file are:
.in +3
.IP -
GATEWAY \fIgw how-often interval\fR - query gateway 
\fIgw how-often\fR times at intervals of \fIinterval\fR.
\fIgw\fR may be specified either as a dot notation IP address
(such as '128.84.248.254') or as a name ('csgwd.rpi.edu').
\fIhow-often\fR can take on the values \fIn\fRTIMES (query \fIn\fR
times, including 1TIMES) or FOREVER (query forever); \fIinterval\fR
determines the interval between queries (in seconds). Note that
\fIinterval\fR has to be specified in integral seconds; specifying
an interval with fractions of a second is an error. A further limit on
\fIinterval\fR is that the value specified may not exceed 2**32 - 1.
As each 
.I sgmpask
process is only intended to query a single gateway, it is an error
to have more than one of these lines in a configuration file.
.IP -
LOG \fIfilename variable\fR - log  values received for variable
\fIvariable\fR in file \fIfilename\fR. In each configuration file,
at least one of these lines should occur.
.IP -
SESSION \fIsession_name\fR - configure the session name for queries
so that it is \fIsession_name\fR. This is a required parameter, that must
occur once in every configuration file.
.in -3
.SH LOG OUTPUT
.LP
Output from sgmpask generally occurs to the UNIX flat files whose
names were specified in the 
.I sgmpask 
configuration file. The format of these files is:
.sp
.in +2
\fITime Stamp	Source IP Address	Variable	Value\fR
.br
.sp
Errors encountered will be logged in an errorlog 'errorlog' residing
in the directory in which sgmpask was started.
.SH FILES
.in +5
/etc/sgmp.variables		The variable initfile
.br
/etc/services			To find the 'sgmp' service
.br
configfile			The sgmpask configfile
.br
errorlog				To log errors
.br
\fIfile\fR					Files to log variable values
.SH SEE ALSO
sgmpquery(l), sgmplookup(l), sgmproute(l), sgmpwatch(l), "A Simple
Gateway Monitoring Protocol", RFC 1028, by J.R. Davin, J.D. Case,
M.S. Fedor, M.L. Schoffstall.
