#include <stdio.h>

#define	SYMTONUM		1	/* symbolic to numeric */
#define	NUMTOSYM		2	/* numeric to symbolic */
#define	CVTIPADD		3	/* convert 32 bit ip address */

typedef struct {
	unsigned short len;
	unsigned char *str;
} string;

static unsigned char sgmp_buffer[80];

unsigned char *sgmp_print_name (name)
    unsigned char *name;
{
    register int i, j, len;

    len = strlen(name);
    for (i = 0; i < len; i++) {
	j = (name[i] & 0xF0) >> 4;
	sgmp_buffer[2*i] = j + (j < 10 ? '0' : '7');
	j = name[i] & 0x0F;
	sgmp_buffer[2*i+1] = j + (j < 10 ? '0' : '7');
    }
    sgmp_buffer[2*i] = '\0';
    return sgmp_buffer;
}
main()
{
    string *ostr, istr;
    unsigned char line[BUFSIZ];

    sgmp_init_cvt("sgmp.variables");
    while(fgets(line, BUFSIZ-1, stdin) != NULL) {
	istr.str = line;
	istr.len = strlen(line);
	line[--istr.len] = '\0';
	ostr = sgmp_var_cvt(&istr, SYMTONUM);
	printf("Symbolic %s is Numeric %s\n", line, ostr ?
	    sgmp_print_name(ostr->str) : (unsigned char *)"not found");
	ostr = sgmp_var_cvt(&istr, NUMTOSYM);
	printf("Numeric %s is Symbolic %s\n", sgmp_print_name(line),
	    ostr ? ostr->str : (unsigned char *)"not found");
	ostr = sgmp_var_cvt(&istr, CVTIPADD);
	printf("IP address %s is Numeric %s\n", line, ostr ? ostr->str :
	    (unsigned char *)"not found");
    }
}
