/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/******************************************************************************
**
**			cvtaddr.c
**
** This file contains two utilities to convert between different forms
** of IP addresses. 'dotto32bit' converts an IP address in dot notation
** to its 32 bit equivalent, while 'stdtodot' converts a (standard) 32 bit
** IP address to dot notation.
**
**
******************************************************************************/
#include "sgmp.h"

#define CONVMASK	((u_long)(~0x00) >> (sizeof(long)-1)*8)

/* dotto32bit - convert an IP address in dot notation to 32bit address */
long
dotto32bit(address)
char *address;			/* null terminated IP address to be converted */
{ long newadd;			/* the new (32 bit) address */
  int i,j,k;			/* indices */
  i = 0;			/* start at the beginning */
  newadd = 0;			/* no address yet */
  for (k=0; k < 4; k++)
/* search for delimiting '.' in address */
   { for(j=i; address[j]!='\0' && address[j]!='.' && isdigit(address[j]); j++) 
			;
     if(address[j] != '.')	/* if no delimiting dot found */
       if(k != 3)		/* if this is not last part of address */
       return(-1);		/* error */
      else			/* this is last part of address */
       if(address[j] != '\0')	/* if loop was left prematurely */
	return(-1);		/* error */
       else			/* loop wasn't left prematurely */
        newadd = (newadd << 8) + (long)atoi(address+i);
     else			/* delimiting dot was found */
      { address[j] = '\0';	/* delimit this part of address */
        newadd = (newadd << 8) + (long)atoi(address+i);
	i = j+1;		/* go on to next part of address */
      }
   }
/* found a decent IP address, return it */
  return(newadd);
} 

/* stdtodot - convert a standard 32 bit address and return the dot notation */
char *
stdtodot(address)
long address;			/* the standard address to be converted */
{ char *newadd;			/* the new address */
/* note that 2 hex digits cannot exceed 3 decimal places, so 8 hex digits
   will not exceed 12 characters. Together with '.', and '\0' == 16 */
  if((newadd = (char *)malloc(16*sizeof(char))) == NULL)
   return((char *)NULL);
  address = htonl(address);	/* in case we are on a screwed up machine */
  sprintf(newadd,"%d.%d.%d.%d",(((char *)(&address))[0] & CONVMASK),
			       (((char *)(&address))[1] & CONVMASK),
			       (((char *)(&address))[2] & CONVMASK),
			       (((char *)(&address))[3] & CONVMASK));
  return(newadd);
}

