/* 
 * Copyright 1987 by Rensselaer Polytechnic Institute 
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of RPI not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission. RPI makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty. 
 *
 */
/***********************************************************************
**                       
**                       table_util.c
**
**      This file contains the various functions to enter and read
** data from the table. For the present a link list  is used . Each
** node in the list is a structure identified by it's request id
** field.
**      The type of table management is expected to change in the
** future revisions of the library.
**      The original coding was so horrible, that I completely redid this
** module.  It should have the same semantics, even when it didn't entirely
** make sense to me.   --clh
**
***********************************************************************/

# include "sgmp.h"

typedef struct sockaddr_in remote_data;
static          remote_data;
typedef remote_data *fpointer;
typedef struct table_node {
  int             req_id;	/* the request id */
  int             sock;		/* the socket file descriptor */
  int             local_port;	/* the local port number */
  fpointer        fhost;	/* remote host information */
  struct table_node *next_node;	/* pointer to next node */
};

static struct table_node *p;	/* pointer to linked list */


/************************************************************************
**        
**                    sgmp_fill_verify_data()
**
**     This function fills or verifies the request id. In case of the former
** the remote host peer structure (sockaddr_in is also filled in .
**
************************************************************************/
sgmp_fill_verify_data(request_id, fdata, flag)	/* fills in the peer
						 * structure */
  int             request_id;
  struct sockaddr_in *fdata;
  int             flag;

{
  struct table_node *temp;	/* a temporary pointer to a node */

  switch (flag) {		/* check what needs to be done */
  case REQ_ANY:		/* the req_id is non-existent */

    if (request_id == REQ_ANY) {/* is table already filled in ? */
      if (p != NULL)		/* if yes, do nothing */
	return (0);
    }

    temp = p;

/* first, see if there is an existing entry */
    while(temp)
      if (temp->req_id == request_id)
	break;
      else
	temp = temp->next_node;

/* if not, create one */
    if (temp == NULL) {
      temp = (struct table_node *) malloc(sizeof(struct table_node));
      if (temp == NULL) {
	fprintf(stderr,
		"Could not allocate memory in table_util.c,exiting...\n");
	exit(1);
      }
      temp->next_node = p;
      temp->req_id = request_id;
      temp->fhost = NULL;
      p = temp;
    }

/* now temp is the entry.  Fill it in. */
    if (temp->fhost)  /* old entry here no longer valid */
      free(temp->fhost);
    temp->fhost =  (struct sockaddr_in *) malloc(sizeof(struct sockaddr_in));
    if (temp->fhost == NULL) {
      fprintf(stderr,
	      "Could not allocate memory in table_util,exiting ...\n");
      exit(1);
    }
    bcopy(fdata, temp->fhost, sizeof(*fdata));
    break;

  case VERIFY_ID:		/* check for id in table */

    temp = p;
    while(temp)
      if (temp->req_id == request_id)
	return(0);
      else
	temp = temp->next_node;
    return (REQID_UNKNOWN);
  }
}


/***********************************************************************
**
**                   sgmp_fill_sd_lport()
**
**    This function fills in the socket file descriptor as well as the
** local port on which communication is taking place for the provide
** request id.
**
***********************************************************************/

sgmp_fill_sd_lport(request_id, socket, lport)
  int             request_id;
  int             socket;
  int             lport;

{
  struct table_node *temp;

/* first, see if there is an existing entry */
  temp = p;
  while(temp)
    if (temp->req_id == request_id)
      break;
    else
      temp = temp->next_node;

/* if not, create one */
  if (temp == NULL) {
    temp = (struct table_node *) malloc(sizeof(struct table_node));
    if (temp == NULL) {
      fprintf(stderr,
	      "Could not allocate memory in table_util.c,exiting...\n");
      exit(1);
    }
    temp->next_node = p;
    temp->req_id = request_id;
    temp->fhost = NULL;
    p = temp;
  }

/* now temp is the entry.  Fill it in. */
  temp->sock = socket;
  temp->local_port = lport;
  return(0);
}

/****************************************************************************
**
**                        sgmp_get_sock()
**
**      This function is called by term_sgmp_comm. It returns the socket
** which needs to be closed, after looking up into the table.
**
***************************************************************************/

sgmp_get_sock(request_id)
  int             request_id;

{
  struct table_node *temp;	/* a temporary pointer */

  /* start searching the list for the given request id */

  temp = p;
  while(temp)
    if (temp->req_id == request_id)
      return(temp->sock);
    else
      temp = temp->next_node;	/* get the next node */

  return (REQID_UNKNOWN);

}

/****************************************************************************
**
**                        sgmp_remove_reqid()
**
**      This function is called by term_sgmp_comm. It removes the table
** entry.
**
***************************************************************************/

sgmp_remove_reqid(request_id)
  int             request_id;

{
  struct table_node *temp;	/* a temporary pointer */

  if (p == NULL)
    return;
  else if (p->req_id == request_id) {
    p = p->next_node;
    return;
  }

  temp = p;
  while(temp->next_node)
    if (temp->next_node->req_id == request_id) {
      temp->next_node = temp->next_node->next_node;
      return;
    }
    else
      temp = temp->next_node;

}

/****************************************************************************
**
**                        sgmp_get_fport()
**
**      This function is used to for retrieving the remote port.
**
***************************************************************************/


sgmp_get_fport(request_id)
  int             request_id;

{
  struct table_node *temp;	/* a temporary pointer */

  /* start searching the list for the given request id */

  temp = p;
  while(temp)
    if (temp->req_id == request_id)
      return (temp->fhost->sin_port);	/* return the remote port */
    else
      temp = temp->next_node;
  return (REQID_UNKNOWN);

}

/***********************************************************************
**
**                        sgmp_clean_table
**
**   This is used for 'cleaning up' the table.
**
**********************************************************************/

void 
sgmp_clean_table()
{
  struct table_node *temp;	/* a temporary pointer */

  while (p) {
    temp = p;
    if (temp->fhost)
      free (temp->fhost);
    p = temp->next_node;
    free (temp);
  }
}

