/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/



/**********************************************************************
**                       send_sgmp_mesg
** 
**  This function is responsible for authenticating a message and passing
** it down to the communication layer to be sent to the provided address.
** In case of a timeout the function returns SEND_TIMEOUT and in any
** other generic failure GEN_ERR is returned. Upon successfully sending
** a packet the size of the packet is returned.
**  The other funtion called are send_sgmp_pkt (communication layer) and
** build_sgmp_pkt (to build a packet).
**
************************************************************************/
#include "sgmp.h"

jmp_buf sjbuf;                        /* buffer to store the stack */

int send_sgmp_mesg(type,req_id,to,service,mesg,session_id,sid_len,timeout)

int type;
int req_id;
int  to;  
char *service;
char *mesg;
char *session_id;
int timeout;
int sid_len;

{
 PACKET build_sgmp_pkt();            /* function to build a packet */
 int send_sgmp_pkt();                /* send pkt at the comm layer */
 int authen_sgmp_send();             /*authenticate the packet */
 void intr_handler_sgmp();           /*to handle a TIMEOUT interrupt */
 struct itimerval *value,*ovalue;    /*for the timer */
 int pkt_len = 0;                    /* length of the data */
 int total_size;                     /* length of packet */
 int i,k;                            /* index */
 unsigned char *message;             /* pointer to the data */
 char *authen_pkt;                   /* pointer to the authenticated pkt*/

  /* allocate memory space for the entire authenticated packet */

 if((authen_pkt = (char *)malloc(MAXLEN)) == NULL){
    fprintf(stderr,"Memory allocation error in send_msg \n");
  exit(1);
  }
 
 /*build the X409 packet */
  message = build_sgmp_pkt(mesg,type,&pkt_len);

  
 /*authenticate the packet with the session_id */
  total_size = pkt_len + sid_len + 3;/* entire length of packet */
 if((authen_sgmp_send(message,authen_pkt,session_id,pkt_len,sid_len)) < 0){
    fprintf(stderr,"Error in authentication(while sending)");
   exit(1); 
  }
  free(message);
 /* set the timer */

 value =(struct itimerval *)malloc(sizeof(struct itimerval));
 ovalue = (struct itimerval *)malloc(sizeof(struct itimerval));

 value->it_value.tv_sec = timeout;    /*set time out period  sec.*/
 value->it_value.tv_usec = 0;         /* the micro second field */

 value->it_interval.tv_sec = 0;       /*set reloading value */
 value->it_interval.tv_usec = 0;      /* the micro second field*/

 setitimer(ITIMER_REAL,value,ovalue); /*start the timer */
 signal(SIGALRM,intr_handler_sgmp);   /* set the interrupt routine */

 if (setjmp(sjbuf) < 0 )
   {free(value);
    free(ovalue);
  return(SEND_TIMEOUT);
  }

 if (( send_sgmp_pkt(service,authen_pkt,req_id,to,total_size)) < 0)
   { value->it_value.tv_sec =  0;         /*reset time out period  sec.*/
     value->it_value.tv_usec = 0;         /* the micro second field */
    setitimer(ITIMER_REAL,value,ovalue);
     return(GEN_ERR);
   }
 free(authen_pkt);
  free(value);
   free(ovalue);
     value->it_value.tv_sec =  0;         /*reset time out period  sec.*/
     value->it_value.tv_usec = 0;         /* the micro second field */
     setitimer(ITIMER_REAL,value,ovalue);
   return(total_size );                   /*the size of the entire packet */
}

/*******************************************************************/

void intr_handler_sgmp()             /* to handle TIMEOUT interrupt */
{
signal (SIGALRM,intr_handler_sgmp);  /* reset interrupt */
 longjmp(sjbuf,-1);
}
