/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/**********************************************************************
**                       authen_sgmp_send
** 
**   This function is responsible for authenticating the outgoing
** packet with its session id at the size of the session id. This
** is expected to grow more complex in the future.
**
************************************************************************/
#include "sgmp.h"



int authen_sgmp_send(mesg,authen_pkt,session_id,pkt_len,sid_len)
char *mesg;
char *authen_pkt;
char *session_id;
int pkt_len;
int sid_len;

{
 int i,k,j;
 int total_size;

 total_size = pkt_len + sid_len + 3;    /*including the  first two bytes */

 /*authenticate the packet with the session_id */

 /* attach the length of the packet */
 authen_pkt[0] = ((char *)(&total_size))[sizeof(int) - 2];/* msbyte */
 authen_pkt[1] = ((char *)(&total_size))[sizeof(int) - 1];/*lsbyte */

 /* attach the length of the session id */
 authen_pkt[2] = ((char *)(&sid_len))[sizeof(int) - 1]; /* one byte */

 /* attach the session id */
 for (i = sid_len,j = 0,k = 3;i != 0;i--)
  authen_pkt[k++] = session_id[j++];

 /* attach the data */
 for(i = pkt_len;i != 0; i--)
  authen_pkt[k++] = *(mesg++);

     return(AUTHEN_OK);                   

}

