/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/**************************************************************************
 **                        recv_sgmp_pkt
 ** This is  a low level function (communication layer) to receive a packet
 ** and pass the pointer to the function (recv_msg) above it. The function
 ** 'init_comm' is invoked if initialization needs to be performed.
 **
 *************************************************************************/
#include "sgmp.h"

#ifndef errno
extern int errno;
#endif /* errno */

#define LHOSTSZ		32	/* length of array for local host name */

struct sockaddr_in server;         /*the local host structure  */

struct sockaddr_in *
recv_sgmp_pkt(service,req_id,received_pkt)
char *service;
int *req_id;
char **received_pkt;

 {
  int i;
  struct sockaddr_in *from;       /* remote host structure */
  struct hostent *fhost;          /*characteristics of remote host */
  int fromlen ;                   /*size of from struct */
  int rcode;                      /*to check for recv */
  int sock;                       /* socket file descriptor */
  void init_sgmp_comm();          /* creation and binding of a socket */
  

/*allocate memory for from */
if((from = (struct sockaddr_in *)malloc(sizeof(struct sockaddr_in))) == NULL)
{fprintf(stderr,"Couldnot allocate memory in recv_send_pkt,exiting ...\n");
exit(1);
 }                                          /* if request id not in table*/
if(sgmp_fill_verify_data(*req_id,NULL,VERIFY_ID) == REQID_UNKNOWN)  
    init_sgmp_comm(*req_id,service);     /* initialize a socket and bind it */
  
  /*clean up remote host structure and assign values*/
        bzero((char *)from,sizeof(*from));
         from->sin_family = AF_INET;
         fromlen = sizeof(*from);

  /* Note: listen and accept have not been used ,as in udp the concept
           of VC does not exist */

 if((sock = sgmp_get_sock(*req_id)) == REQID_UNKNOWN) /* get the socket */
{fprintf(stderr,"SGMPASK :: REQID_UNKNOWN : don't know where to receive message from\n");
      exit(0);
}       

  do
     rcode = recvfrom(sock,*received_pkt,MAXLEN,0,from,&fromlen);
  while(rcode < 0); 
#ifdef DEBUG
{
    char *p = *received_pkt;
    int i;
    printf("\ninput data(%d):\n", rcode);
    for (i = 0; i < rcode; i++) {
	if ((i % 30) == 0) putchar('\n');
	printf(" %0x", p[i]);
    }
    printf("\n");
}
#endif
 return(from);
  }


/************************************************************************
 **                      send_sgmp_pkt
 **
 **  This function is used to send packets to a gateway. The function
 ** init_sgmp_comm is invoked if a socket is not bound and set up. 
 **
 ***********************************************************************/

 int send_sgmp_pkt(service,packet_ptr,req_id,net_addr,size)
 char *service;
 char *packet_ptr;
 int req_id;
 int size,net_addr;                  /* size of the total packet, IP address */

{  
 struct sockaddr_in to;              /*the client structure (remote host)*/
 int tolen;                          /* size of 'to' */
 int rcode;                          /* to check if sent */
 int sock;                           /* socket file descriptor */
 void init_sgmp_comm();              /*to initialize the socket*/
 struct servent *reply;		     /* to get the service entity */

 tolen =  sizeof(to);
                                     /* if id not in table */
if(sgmp_fill_verify_data(req_id,NULL,VERIFY_ID) == REQID_UNKNOWN)
 init_sgmp_comm(req_id,NULL);        /* initialize socket and bind it*/
                                     /* NOTE: the service is not required */
    bzero((char *)&to,sizeof(to));   /* 'clean' remote host structure */
    to.sin_addr.s_addr = net_addr;   /* the remote host address */


  /*prepare the remote host structure */
    to.sin_addr.s_addr = (u_long)htonl(net_addr);
    to.sin_family = AF_INET;
  if(service != NULL)    /* send to a specific port depending on application*/
      { if((reply =  getservbyname(service,"udp")) == NULL)
         { fprintf(stderr,"SGMP :: Error in getservbyname \n");
           exit(1);
         }
        to.sin_port = reply->s_port;         /* assign the port */
      }

       else                         /* this is a reply to a message */
	  to.sin_port = sgmp_get_fport(req_id);

    sock =  sgmp_get_sock(req_id);  /* get the socket file descriptor */

  /* Since datagram sockets are in use,taking into account there und
     undependability the following has to be in a loop  */
#ifdef DEBUG
{
    char *p = packet_ptr;
    int i;
    printf("\noutput data(%d):\n", size);
    for (i = 0; i < size; i++) {
	if ((i % 30) == 0) putchar('\n');
	printf(" %0x", p[i]);
    }
    printf("\n");
}
#endif
  do                    
   rcode = sendto(sock,packet_ptr,size,0,&to,tolen);/*send*/
  while(rcode < 0 );

  return;
 }


/***********************************************************************
 **                       init_sgmp_comm
 ** 
 ** This function is responsible for the creation of the socket and its
 ** binding. It can be invoked either by recv_sgmp_pkt or send_sgmp_pkt.
 **
 **********************************************************************/

void init_sgmp_comm(req_id,service)
int req_id;
char *service;
{
struct protoent *pp;             /*to hold the protocol structure */
struct hostent *lhost;           /*charecteristics of the local host*/
struct servent *s_ent;		 /* for getting the port */
char lhostname[LHOSTSZ];          /*name of the local host*/
int sock;                        /*socket number*/
int lport;                       /* used for assigning a local port */

/* prior to creating a socket - get the protocols the host characteristics
  etc..... */

if((gethostname(lhostname,sizeof(lhostname))) < 0){/*get local host name*/
perror("Error in gethostname:");
 exit(1);
}

do                               /*get the local host structure */
lhost = gethostbyname(lhostname);
while(lhost != NULL && lhost->h_addrtype !=AF_INET);

if(lhost == NULL)                /* perform check on local host name */
  { perror("Error in gethostbyname:");
    exit(1);
  }


  pp = getprotobyname("udp");
  if(pp == NULL)                 /* check the protocol */
    {perror("Error in getprotobyname:");
   exit(1);
   }
     /*socket creation */

  if((sock = socket(AF_INET,SOCK_DGRAM,0)) < 0) {
    perror("Error while creating socket:");
  exit(1);
 }
 
    /* prepare the local host structure, and bind it */

bzero((char *)&server,sizeof(server));
#ifdef notdef
bcopy(&lhost->h_addr,(char *)&server.sin_addr,lhost->h_length);
#endif
server.sin_family = AF_INET;
if(service != NULL)
 { if((s_ent = getservbyname(service,"udp")) == NULL)
    { fprintf(stderr,"SGMP :: ERROR in call to getservbyname\n");
      exit(1);
    }
    server.sin_port = s_ent->s_port;
 }
 /* Now, bind the port */
 if((bind(sock,&server,sizeof(server))) < 0)
   {perror(" Error in bind ::");
    exit(1);
  }
#ifdef notdef
 else  /* scan 10,900 to (10,900 + 1024) for a free port */
   {lport = 10900 + 1024;
    for(;;)
      {server.sin_port = htons((u_short)lport);
       if(bind(sock,&server,sizeof(server)) >= 0) 
	 break;
       if(errno != EADDRINUSE && errno != EADDRNOTAVAIL)
	 {    perror("Error in bind:");
	      exit(1);
	    }
       lport--;
       if(lport == 10900 + 1024)
	 {fprintf(stderr,"Bind :: All ports in use\n");
	  exit(1);
	}
     }
  }
#endif
 /* fill in the table with the socket file descriptor and local port */
  sgmp_fill_sd_lport(req_id,sock,server.sin_port);
  
    return;
 }


/***************************************************************************
**                         term_sgmp_comm
**
**    This fuction is used to terminate communication. This is called just
** before an exit (or reinitialization) of an SGMP application.
**
**************************************************************************/

void term_sgmp_comm(req_id)
int req_id;

{
 int sock;                              /* socket file descriptor */

 sock = sgmp_get_sock(req_id);          /* get the socket, given req_id*/
 sgmp_remove_reqid(req_id);
 if ( close(sock) < 0){                 /* close the socket */
   perror("Could not close socket %d :",sock);
   exit(1);
 }
}
