/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*************************************************************************
 ** This is a synchronous low level function for receiving an SGMP reply.This
 ** return a stucture containing the data.The address of the the gateway
 **sending the reply will be in *from and the the session
 ** ID will be striped of the incoming message and will be contained in
 ** **session ID.
 ** If there is an error in the message it is dicarded.
 *************************************************************************/
#include "sgmp.h"

char *
recv_sgmp_mesg(from,service,req_id,type,session_id)

 int *from;                 
 char *service;
 int *req_id;         
 int *type; 
 char **session_id ; 
                    
{

 char **packet_ptr;                   /* pointer to process the packet */
 unsigned int packet_len;             /*length of the entire packet */
 int *sid_len;                        /* length of the session id */
 char *reply;                         /* A pointer to the parsed message */
 int data_len;                        /* length of the data received */
 struct sockaddr_in *from_data;       /*details of the remote host */
 struct sockaddr_in *recv_sgmp_pkt(); /* to get the packet */
 unsigned int get_len_pkt();          /* to get strip the packet length */
 char *parse_sgmp_pkt();              /* to parse the received packet */

 packet_ptr = (char **)malloc(sizeof(char *));
   if(packet_ptr == NULL)
    {fprintf(stderr,"malloc error in obtaining packet_ptr\n");
     exit(1);
    }

   if((*packet_ptr = (char *)malloc(MAXLEN)) == NULL)
     {fprintf(stderr,"Cannot allocate memory in recv_sgmp_mesg,exiting...\n");
       exit(1);
     }
                                         /*receive from the comm. layer */
label:      from_data = recv_sgmp_pkt(service,req_id,packet_ptr);
                                         
           *from = from_data->sin_addr.s_addr; /* remote host data */
 
  /*get the length of the entire packet and the length of the session id */ 

    packet_len = get_len_pkt(*packet_ptr);
   *packet_ptr += 2;                          /* increment to next field */
    sid_len = (int *) malloc(sizeof(int));    /*allocate memory*/

  /* authenticate the packet */
 if(authen_sgmp_recv(packet_ptr,session_id,sid_len) < 0)/* if error */
   {fprintf(stderr,"SGMP :: recv_sgmp_mesg : Unsuccessful authentication\n");
		goto label;                  /*ignore the entire packet */
  }

  data_len = packet_len - *sid_len - 3;    /* size of the data field */

  /*call the X.409 parser */

 if((reply =  parse_sgmp_pkt(*packet_ptr,data_len,type))==NULL) /* if parse error */
   {fprintf(stderr,"SGMP :: recv_sgmp_mesg : X.409 parse error\n");
	    goto label;                   /*ignore packet; get the next one */
  }

/* free(*packet_ptr); */
 switch(*req_id)
   {     
   case REQ_ANY:                        
      if(*type == TRP_REQ_MESG)            /* the req_id is REQ_ANY */
	{
          sgmp_fill_verify_data(REQ_ANY,from_data,REQ_ANY);
            return(reply);                /*  return to upper function*/
	}

         else                             /* a req. to fill the table */
          {  
            *req_id = ((get_req_msg_type *)reply)->request_id;
            sgmp_fill_verify_data(*req_id,from_data,REQ_ANY);

    /* fill in the local socket file descriptor, if not trap message */
    /* Here filling in of the local port is of no importance */

          sgmp_fill_sd_lport(*req_id,sgmp_get_sock(REQ_ANY),0);
            return((char *)reply);
	  }

   default:
 if(sgmp_fill_verify_data(*req_id,from_data,VERIFY_ID) < 0)/* if unknown req_id */
   {fprintf(stderr,"SGMP :: recv_sgmp_mesg : The message request id is unknown\n");
            goto label;                   /* ignore packet; get next one */
  }
	return(reply);            /* return the message */
 }
}
/*********************************************************************/

unsigned int get_len_pkt(pointer)         /* function to convert to bytes
                                            of data to a number */
  unsigned char *pointer; 
 {
    unsigned int numb; /* integer to be returned */
                 numb = (unsigned int)(*pointer);
                 numb = (numb << 4) | (unsigned int)(*(pointer + 1));
                 return(numb); 
 }  

 
