/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/****************************************************************************
 **                         authen_sgmp_recv
 **
 ** This is the authentication required for the SGMP while receiving packets.
 **  At present it involves the striping of the session id only. The
 **  authentication is expected to  get more complex. At present this returns
 ** a AUTHEN_OK for sucess and an integer less than zero if an error occurs.
 ** The stripped of session_id is put into *session_id.
 **
 ***************************************************************************/
#include "sgmp.h"

int authen_sgmp_recv(packet_ptr,session_id,sid_len)

  char **packet_ptr;
  char **session_id;
  int *sid_len;

 {
   char *ptr;                               /* temp. pointer */
  int i,k;                                  /* index */
  int get_sid_len();                        /* convert 1 byte of char to int */

 
  k = *sid_len = get_sid_len(*packet_ptr);  /* Get length of the session id */

  if(*sid_len < 0 )
       return(AUTHEN_ERR);                  /* Error in authentication */

   (*packet_ptr)++;                         /* point to the sid */

   *session_id = (char *)malloc(sizeof(char) * (1 + *sid_len));

 /* pass the session id to the calling function */

 for(i = 0,ptr = *packet_ptr; ptr < (*packet_ptr + *sid_len); )
{                                             
   (*session_id)[i++] = *ptr;               /* strip session id */
       ptr++;                               /* increment the pointer */
 }
   (*session_id)[i++] = '\0';               /* End the string */
   
/*   free( ptr ); */

   for( ;k != 0 ;k--)
    (*packet_ptr)++ ;                       /* point to the data */

  return(AUTHEN_OK);                        /* successful authentication */

 }

/*************************************************************************/

int get_sid_len(ptr)                         /* function to return integer */
char *ptr; 

{
  int numb;
    numb = (int)(*ptr);
    return(numb);
}

