/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/*****************************************************************************
**
**		parse_types.c
**
** This file contains small functions that do not justify a file of their
** own, but are not sufficiently low-level that they can be in
** parse_util.c either (these functions don't do manipulations at the
** bit or byte  level).
**
**
*****************************************************************************/
#include "sgmp.h"		/* the general include file */
#include "X409.h"		/* X.409 specific definitions */

#define parse_name(a,b,c)	parse_string(a,b,c)

/* parse_value - parse the value of a variable. Parses the 'var_value_type' */
PACKET
parse_value(current,var_value,typelen)
PACKET current;			/* the packet segment to be parsed */
var_value_type *var_value;	/* the value to be filled in */
int *typelen;			/* the length of the type - not the value */
{ int type;			/* the type - either integer or a string type */
/* allocate structure for variable value */
  switch(*current) {		/* check what sort of structure it is */
   case INT_TYP:
    var_value->type = INTEGER;
    current = parse_int(current,(long *)&(var_value->value.intgr),typelen);
    break;
   case PRM_STR:
   case CON_STR:
    var_value->type = PRIM_STR;
    current = parse_string(current,(strng **)&(var_value->value.str),typelen);
    break;
   default: return((PACKET) NULL); break;
  }
  return(current);
}

/* parse_var_list - parse and fill in the variable list */
/* this function parses the 'var_op_list_type' */
PACKET
parse_var_list(current,mesg,cont_len)
PACKET current;			/* packet to be parsed */
get_req_msg_type *mesg;		/* the message structure to be filled in */
int *cont_len;			/* remaining length of the packet */
{ int list_len;			/* length of variable list */
  int type;			/* type - should be SEQUENCE */
  PACKET old_current;		/* old current */
/* make sure we have a list, and get the length of the list */
  current = parse_header(current,cont_len,&type,&list_len);
  if (current == NULL)		/* if there was an error */
   { mesg->var_op_list = NULL;	/* indicate error */
     return((PACKET)NULL);	/* return */
   }
  if (type != SEQUENCE)	/* check that we actually have a list */
   { mesg->var_op_list = NULL; /* indicate error */
     return((PACKET)NULL);
   }
/* parse list, filling in mesg structure one way or the other */
  old_current = current;	/* save value of current */
  if (list_len == ISINDEFINITE) /* packet is of indefinite length */
   { while ((current[0] != EOCID) || (current[1] != EOCLEN))
      { current = parse_var_type(current,mesg,&list_len);
	if(current == NULL)	/* if there was an error */
	  return((PACKET)NULL);
      }
     current += 2;		/* move past end of list */
   }
  else				/* list is of fixed length */
   { while (list_len > 0)	/* while not end of list */
      { current = parse_var_type(current,mesg,&list_len);
        if (current == NULL)
         return((PACKET)NULL);
      }
   }
  if(*cont_len != ISINDEFINITE)
   { *cont_len -= (current - old_current);
     if (*cont_len < 0)	/* if length is wrong */
      return((PACKET)NULL);
   }
  return(current);
}

/* parse_var_type - parse the variable type */
/* this function parses the 'var_op_type' type */
PACKET
parse_var_type(current,mesg,list_len)
PACKET current;			/* the packet to be parsed */
get_req_msg_type *mesg;		/* the message structure to be filled in */
int *list_len;			/* length of the list */
{ int type;			/* type - should be SEQUENCE */
  int type_len;			/* length of type */
  PACKET old_current;		/* old current */
  var_op_type *p;		/* temporary */
  current = parse_header(current,list_len,&type,&type_len);
  if (current == NULL)		/* if there was an error */
   { mesg->var_op_list = NULL;	/* indicate error */
     return((PACKET)NULL);	/* return */
   }
  if(type != SEQUENCE)		/* make sure that type is correct */
   { mesg->var_op_list = NULL;	/* indicate error */
     return((PACKET)NULL);	/* return */
   }
/* allocate space for new variable */
  if(mesg->var_op_list == NULL)	/* if this is first variable */
   { mesg->var_op_list = (var_op_type *)malloc(sizeof(var_op_type));
     if(mesg->var_op_list == NULL) /* malloc error? */
       return((PACKET)NULL);
     p = mesg->var_op_list;	/* point at cell to be filled in */
     mesg->var_op_list->var_next = NULL; /* no successors right now */
   }
  else				/* this isn't first variable */
   { p = mesg->var_op_list;	/* start at the beginning */
     while(p->var_next != NULL)	/* while end of list not reached */
       p = p->var_next;		/* go into list further */
/* end of list now reached. Allocate new variable */
     p->var_next = (var_op_type *)malloc(sizeof(var_op_type));
     if(p->var_next == NULL)	/* malloc error? */
      { mesg->var_op_list = NULL; /* indicate error */
        return((PACKET)NULL);
      }
     p->var_next->var_next = NULL; /* no successors yet */
     p = p->var_next;		/* point at cell to be filled in */
   }
/* fill in variable fields */
  old_current = current;	/* save old value of current */
  if(type_len == ISINDEFINITE)	/* if the length of the type is indefinite */
   { current = parse_name(current,(strng **)(&(p->var_name)),&type_len);
     if (current == NULL)	/* if there was an error */
       { mesg->var_op_list = NULL; /* indicate error */
         return((PACKET)NULL);	/* return */
       }
     current = parse_value(current,&(p->var_value),&type_len);
     if (current == NULL)	/* if there was an error */
       { mesg->var_op_list = NULL; /* indicate error */
         return((PACKET)NULL);	/* return */
       }
/* if end of variable value not reached */
     if ((current[0] != EOCID) || (current[1] != EOCLEN))
       { mesg->var_op_list = NULL; /* indicate error */
         return((PACKET)NULL);	/* return */
       }
     else			/* we did reach the end of the var value */
       current += 2;		/* move past EOC */
   }
  else				/* length of type is fixed */
   { current = parse_name(current,(strng **)(&(p->var_name)),&type_len);
     if (current == NULL)	/* if there was an error */
       { mesg->var_op_list = NULL; /* indicate error */
         return((PACKET)NULL);	/* return */
       }
     current = parse_value(current,&(p->var_value),&type_len);
     if (current == NULL)	/* if there was an error */
       { mesg->var_op_list = NULL; /* indicate error */
         return((PACKET)NULL);	/* return */
       }
     if(type_len != 0)		/* if end of variable not reached */
       { mesg->var_op_list = NULL; /* indicate error */
         return((PACKET)NULL);	/* return */
       }
   }
  if(*list_len != ISINDEFINITE)	/* if length isn't indefinite */
   { *list_len -= (current - old_current);
     if(*list_len < 0)		/* if length is wrong */
      return((PACKET)NULL);
   }
  return(current);
}

/* parse_val_list - parse a list of variable values */
PACKET
parse_val_list(current,mesg,mesg_len)
PACKET current;
trap_req_msg_type *mesg;
int *mesg_len;
{ int type;			/* type - should be sequence */
  int len;			/* length of list */
  val_list_type *p,*q;		/* temporary */
  PACKET old_current;		/* old mesg_len; */
  current = parse_header(current,mesg_len,&type,&len); /* get header info */
  if (current == NULL)		/* if there was an error */
   { mesg->val_list = NULL;	/* indicate error */
     return((PACKET)NULL);	/* return */
   }
  if (type != SEQUENCE)		/* make sure we have a list */
   { mesg->val_list = NULL;	/* indicate error */
     return((PACKET)NULL);	/* return */
   }
/* allocate space for first new variable */
  if(mesg->val_list == NULL)	/* first variable? */
   { mesg->val_list=(val_list_type *)malloc(sizeof(val_list_type));
     if (mesg->val_list == NULL) /* malloc error? */
      return((PACKET)NULL);
     p = mesg->val_list;	/* point at cell to be filled in */
     mesg->val_list->var_next = NULL; /* no successors yet */
   }
  else				/* this isn't first variable */
   { p = mesg->val_list;	/* start at the beginning */
     while (p->var_next != NULL) /* while end of list not reached */
      p = p->var_next;		/* go into list further */
/* end of list now reached. Allocate new variable */
     p->var_next = (val_list_type *)malloc(sizeof(val_list_type));
     if(p->var_next == NULL)	/* malloc error? */
      { mesg->val_list = NULL; /* indicate error */
        return((PACKET)NULL);	/* return error */
      }
     p->var_next->var_next = NULL; /* no successors yet */
     p = p->var_next;		/* point at cell to be filled */
   }
/* fill in variable values */
  old_current = current;	/* save old value of current */
  if (len == ISINDEFINITE)	/* if we have an indefinite length list */
/* if this is a null list */
   { if ((current[0] == EOCID) && (current[1] == EOCLEN))
      { mesg->val_list == NULL; /* value list is null */
        current += 2;		/* move past EOC */
        if(*mesg_len != ISINDEFINITE)	/* if length is not indefinite */
         { *mesg_len -= (current - old_current);
           if (*mesg_len < 0)	/* if length is wrong */
           return((PACKET)NULL);
         } 
        free(p);		/* free the extra variable */
        return(current);
      }
     do				/* iterate to get variables */
      { current = parse_value(current,&(p->var_op),&len);
        if (current == NULL)	/* there was a parse error */
         return((PACKET)NULL);	/* return an error indicator */
/* allocate space for new variable */
        p->var_next = (val_list_type *)malloc(sizeof(val_list_type));
        if(p->var_next == NULL)	/* malloc error? */
         { mesg->val_list = NULL; /* indicate error */
           return((PACKET)NULL); /* return error */
         }
        p->var_next->var_next = NULL; /* no successors yet */
        p = p->var_next;	/* point at cell to be filled */
      } while ((current[0] != EOCID) || (current[1] != EOCLEN)); 
     current += 2;		/* move past end of list */
   }
  else				/* list is of fixed length */
   { if (len <= 0)		/* make sure we don't have null list */
      { mesg->val_list == NULL;
        if(*mesg_len != ISINDEFINITE)	/* if length is not indefinite */
         { *mesg_len -= (current - old_current);
           if (*mesg_len < 0)	/* if length is wrong */
           return((PACKET)NULL);
         } 
        free(p);		/* free the extra variable */
        return(current);
      }
     do				/* iterate to get variables */
      { current = parse_value(current,&(p->var_op),&len);
        if (current == NULL)	/* there was a parse error */
         return((PACKET)NULL);	/* return an error indicator */
/* allocate space for new variable */
        p->var_next = (val_list_type *)malloc(sizeof(val_list_type));
        if(p->var_next == NULL)	/* malloc error? */
         { mesg->val_list = NULL; /* indicate error */
           return((PACKET)NULL); /* return error */
         }
        p->var_next->var_next = NULL; /* no successors yet */
        p = p->var_next;	/* point at cell to be filled */
      } while (len > 0);	/* while we haven't reached end of list */
   }
  if(*mesg_len != ISINDEFINITE)	/* if length is not indefinite */
   { *mesg_len -= (current - old_current);
     if (*mesg_len < 0)	/* if length is wrong */
      return((PACKET)NULL);
   } 
/* we will always have an extra variable - deallocate it */
/* find extra variable */
  for(q=mesg->val_list; q->var_next != p; q = q->var_next)
		;
  q->var_next = NULL;		/* remove extra variable from list */
  free(p);
  return(current);
}
