/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/******************************************************************************
**
**			parse_sgmp_pkt.c
**
** 'Top level' program for parsing an incoming packet in the Simple
** Gateway Monitoring Protocol. It will parse the header and determine
** the length of the contents of the packet using 'parse_header' (in
** parse_util.c) and then call a function in file 'parse_msgs.c' to
** parse the message (contents of the packet) as appropriate.
**
**
******************************************************************************/
#include "sgmp.h"		/* the general include file */
#include "X409.h"		/* X409 specific definitions */

#define parse_rsp_mesg(a,b,c) parse_req_mesg(a,(get_req_msg_type *)b,c)
#define parse_set_mesg(a,b,c) parse_req_mesg(a,(get_req_msg_type *)b,c)

/* parse_sgmp_pkt - parse an incoming packet. Returns type of message */
char *
parse_sgmp_pkt(packet,pkt_len,mesg_type)
PACKET packet;			/* the incoming packet */
int pkt_len;			/* length of packet */
int *mesg_type;			/* type of message received */
{ int type;			/* the type of packet received */
  int cont_len;			/* length of packet contents */
  get_req_msg_type *req_msg;	/* Get Request Message */
  get_rsp_msg_type *rsp_msg;	/* Get Response Message */
  trap_req_msg_type *trp_msg;	/* Trap Request Message */
  set_req_msg_type *set_msg;	/* Set Request Message */
  packet = parse_header(packet,&pkt_len,&type,&cont_len); /* parse id and len */
  if (packet == NULL)	/* there was an error in finding type or length */
    return((char *)NULL);
/*
   couldn't pass pkt_len directly to parse_header because it is used
   in parse_header.
*/
/* allocate appropriate message buffers */
  switch (type) {
   case GET_REQ_MESG:		/* Get Request Message */
		req_msg = (get_req_msg_type *)malloc(sizeof(get_req_msg_type));
		if (req_msg == NULL)
		  return((char *)NULL);
		req_msg->request_id = 0;
		req_msg->error_status = 0;
		req_msg->error_index = 0;
		req_msg->var_op_list = NULL;
		if (parse_req_mesg(packet,req_msg,&cont_len) != PARSE_OK)
		  return((char *)NULL);
		/* if this point is reached, the parse was successful */
		*mesg_type = GET_REQ_MESG; /* type of message is a request */
		return((char *)req_msg);
		break;
   case GET_RSP_MESG:		/* Get Response Message */
		rsp_msg = (get_rsp_msg_type *)malloc(sizeof(get_rsp_msg_type));
 		if (rsp_msg == NULL)
		  return((char *)NULL);
		rsp_msg->request_id = 0;
		rsp_msg->error_status = 0;
		rsp_msg->error_index = 0;
		rsp_msg->var_op_list = NULL;
		if(parse_rsp_mesg(packet,rsp_msg,&cont_len) != PARSE_OK)
		  return((char *)NULL);
		/* if this point is reached, the parse was successful */
		*mesg_type = GET_RSP_MESG; /* type of message is a response */
		return((char *)rsp_msg);
		break;
   case TRP_REQ_MESG:		/* Trap Request Message */
		trp_msg =(trap_req_msg_type *)malloc(sizeof(trap_req_msg_type));
		if (trp_msg == NULL)
		  return((char *)NULL);
		trp_msg->trap_type = 0;
		trp_msg->val_list = NULL;
		if(parse_trap_mesg(packet,trp_msg,&cont_len) != PARSE_OK)
		  return((char *)NULL);
		/* if this point is reached, the parse was successful */
		*mesg_type = TRP_REQ_MESG; /* type of message is a trap */
		return((char *)trp_msg);
		break;
   case SET_REQ_MESG:		/* Set Request Message */
		set_msg = (set_req_msg_type *)malloc(sizeof(set_req_msg_type));
 		if (set_msg == NULL)
		  return((char *)NULL);
		set_msg->request_id = 0;
		set_msg->error_status = 0;
		set_msg->error_index = 0;
		set_msg->var_op_list = NULL;
		if(parse_set_mesg(packet,set_msg,&cont_len) != PARSE_OK)
		  return((char *)NULL);
		/* if this point is reached, the parse was successful */
		*mesg_type = SET_REQ_MESG; /* type of message is a response */
		return((char *)set_msg);
		break;
   default:			/* Unknown message type */
		*mesg_type = UNKNOWN_TYPE;
		return((char *)NULL);
  }
}
