/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*****************************************************************************
**
**			parse_msgs.c
**
** This file contains the functions used in the Simple Gateway Monitoring
** protocol used to parse messages (ie: the contents of packets).
** The multitude of macro definitions is intended to take advantage
** of the number of types defined in the Simple Gateway Monitoring
** Protocol that are actually integers.
**
**
*****************************************************************************/
#include "sgmp.h"
#include "X409.h"

#define parse_req_id_type(a,b,c)	parse_int(a,(long *)b,c)
#define parse_err_stat(a,b,c)		parse_int(a,(long *)b,c)
#define parse_err_index(a,b,c)		parse_int(a,(long *)b,c)
#define parse_trp_typ(a,b,c)		parse_int(a,(long *)b,c)

/* parse_req_mesg - parse (contents of) a Get Request Message */
parse_req_mesg(current,mesg,mesg_len)
PACKET current;			/* start of octets to be processed */
get_req_msg_type *mesg;		/* the message */
int *mesg_len;			/* length of message */
{ 
/* parse the various fields in a Get Request Message */
  current = parse_req_id_type(current,&(mesg->request_id),mesg_len);
  if(current == NULL)
	return(PARSE_ERROR);
  current = parse_err_stat(current,&(mesg->error_status),mesg_len);
  if(current == NULL)
	return(PARSE_ERROR);
  current = parse_err_index(current,&(mesg->error_index),mesg_len);
  if(current == NULL)
	return(PARSE_ERROR);
  current = parse_var_list(current,mesg,mesg_len);
  if(current == NULL)
	return(PARSE_ERROR);
  return(PARSE_OK);
}

/* parse_trap_mesg - parse (contents of) a Trap Request Message */
parse_trap_mesg(current,mesg,mesg_len)
PACKET current;			/* start of octets to be processed */
trap_req_msg_type *mesg;	/* the message */
int *mesg_len;
{ 
/* parse the various fields in a Trap Request Message */
  current = parse_trp_typ(current,&(mesg->trap_type),mesg_len);
  if(current == NULL)
	return(PARSE_ERROR);
  current = parse_val_list(current,mesg,mesg_len);
  if(current == NULL)
	return(PARSE_ERROR);
  return(PARSE_OK);
}
