/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/*****************************************************************************
**
**			build_sgmp_pkt.c
**
** 'build_pkt' is the 'top level' function for building an outgoing
** packet from the structure it receives. It will determine the type
** packet to be built, call 'build_header' (which may be found in
** 'build_util.c') and then call a function in 'build_msgs.c'
** to build the message (contents of the packet) as appropriate.
**
**
***************************************************************************/
#include "sgmp.h"		/* the general include file */
#include "X409.h"		/* X409 specific definitions */

#define build_rsp_mesg(a,b,c,d) build_req_mesg((get_req_msg_type *)a,b,c,d)

/*
   build_sgmp_pkt - build a packet given a structure and a message type   
   returns a pointer to the packet built, together with the length
   of the packet, in *pkt_len; returns null in the event of error,
   returns null and initializes *pkt_len to PKT_OVERFLOW in the event
   that the packet is definitely too long;
*/
PACKET
build_sgmp_pkt(mesg,mesg_type,pkt_len)
char *mesg;
int mesg_type;
int *pkt_len;
{ PACKET packet;		/* actual packet to be returned */
  PACKET pkt_cont;		/* for pkt contents when building packet */
  PACKET pkt_head;		/* packet header built here */
  int cont_len,header_len;	/* length of contents, length of header */
  int i;			/* to copy things in */
  int j,k;			/* temporary variables */
/* allocate space for packet header, contents */
  if((pkt_head = (PACKET)malloc(HEADLEN*sizeof(char))) == NULL)
   return((PACKET)NULL);
  if((pkt_cont = (PACKET)malloc(CONTLEN*sizeof(char))) == NULL)
   return((PACKET)NULL);
/* initialize length of packet. If maximum length MAXLEN exceeded, this will
   return with value PKT_OVERFLOW */
  *pkt_len = 0;
/* construct the contents of the packet */
  switch (mesg_type) {
   case GET_REQ_MESG:		/* Get Request Message */
    if(build_req_mesg(((get_req_msg_type *)mesg),&cont_len,pkt_cont,pkt_len)==NULL)
     return((PACKET)NULL);
    break;
   case SET_REQ_MESG:		/* Set Request Message */
    if(build_req_mesg(((set_req_msg_type *)mesg),&cont_len,pkt_cont,pkt_len)==NULL)
     return((PACKET)NULL);
    break;
   case GET_RSP_MESG:		/* Get Response Message */
    if(build_req_mesg(((get_rsp_msg_type *)mesg),&cont_len,pkt_cont,pkt_len)==NULL)
     return((PACKET)NULL);
    break;
   case TRP_REQ_MESG:		/* Trap Request Message */
    if(build_trap_mesg(((trap_req_msg_type *)mesg),&cont_len,pkt_cont,pkt_len)==NULL)
     return((PACKET)NULL);
    break;
   default:			/* no such message type */
    return((PACKET)NULL);
  }
/* construct the packet header */
   if(build_header(mesg_type,cont_len,&header_len,pkt_head,pkt_len) == NULL)
        return((PACKET)NULL);
/* construct actual packet */
  packet = (PACKET)malloc((*pkt_len+1)*sizeof(char));
  if (packet == NULL)		/* couldn't allocate a packet? */
    return((PACKET)NULL);
/* for some strange reason 'sprintf' and strcpy both mung the packet */
  for(i=0; i < header_len; i++)
   packet[i] = pkt_head[i];
  j = cont_len+header_len;
  for(k = 0;i < j; i++,k++)
   packet[i] = pkt_cont[k];
  free(pkt_head); free(pkt_cont);
  return(packet);
}
