/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/******************************************************************************
**
**			build_msgs.c
**
** This file contains the functions to build the packet contents
** for the various message types supported by the Simple Gateway
** Monitoring Protocol. The multitude of macro definitions is intended
** to take care of the number of types defined in SGMP that are actually
** integers.
**
**
*****************************************************************************/
#include "sgmp.h"		/* the usual include file */
#include "X409.h"		/* X.409 specific definitions */

#define build_req_id(a,b,c,d)		build_int(a,b,c,d)
#define build_err_stat(a,b,c,d)		build_int(a,b,c,d)
#define build_err_index(a,b,c,d)	build_int(a,b,c,d)
#define build_trp_typ(a,b,c,d)		build_int(a,b,c,d)

/* build_req_mesg - build (contents of) a Get Request Message */
PACKET
build_req_mesg(mesg,cont_len,pkt_cont,pkt_len)
get_req_msg_type *mesg;	/* mesg to be packetized */
int *cont_len;			/* length of contents to be returned here */
PACKET pkt_cont;		/* place to build packet contents */
int *pkt_len;			/* length of packet so far */
{ int req_id_len;		/* length of request id */
  int err_index_len;		/* length of error index */
  int err_stat_len;		/* length of error status */
  int list_len;			/* length of list */
  PACKET current;		/* current first empty spot in packet */
/* build the request id */
  current = build_req_id(pkt_cont,mesg->request_id,&req_id_len,pkt_len);
  if (current == NULL)		/* if there was an error */
	return((PACKET)NULL);
  current=build_err_stat(current,mesg->error_status,&err_stat_len,pkt_len);
  if (current == NULL)		/* if there was an error */
	return((PACKET)NULL);
  current=build_err_index(current,mesg->error_index,&err_index_len,pkt_len);
  if (current == NULL)		/* if there was an error */
	return((PACKET)NULL);
  current=build_var_list(current,mesg->var_op_list,&list_len,pkt_len);
  if (current == NULL)		/* if there was an error */
	return((PACKET)NULL);
  *cont_len = req_id_len + err_stat_len + err_index_len + list_len;
  return(current);
}

/* build_trap_mesg - build (contents of) a Trap Request Message */
PACKET
build_trap_mesg(mesg,cont_len,pkt_cont,pkt_len)
trap_req_msg_type *mesg;	/* mesg to be packetized */
int *cont_len;			/* length of contents to be returned here */
PACKET pkt_cont;		/* place to build packet contents */
int *pkt_len;			/* length of packet so far */
{ int trp_typ_len;		/* length of trap type */
  int val_list_len;		/* length of value list */
  PACKET current;		/* current first empty spot in packet */
  current=build_trp_typ(pkt_cont,mesg->trap_type,&trp_typ_len,pkt_len);
  if (current == NULL)		/* if there was an error */
	return((PACKET)NULL);
  current=build_val_list(current,mesg->val_list,&val_list_len,pkt_len);
  if (current == NULL)		/* if there was an error */
	return((PACKET)NULL);
  *cont_len = trp_typ_len + val_list_len;
  return(current);
}
