/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/*****************************************************************************
**
**			varcvt.h
**
** This is the header file for the translator that converts SGMP
** variables from symbolic to numeric form and vice-versa. This converter
** will convert variables of form:
**
**	<symbolic prefix><dot notation IP address> to 
**	<numeric prefix><32 bit IP address>;		(SYMTONUM conversion)
**
**	<symbolic prefix><32 bit IP address> to 
**	<numeric prefix><32 bit IP address>;		(CVTIPADD conversion)
**
** as well as
**
**	<numeric prefix><32 bit IP address> to
**	<symbolic prefix><dot notation IP address>	(NUMTOSYM conversion)
**
**
************************************************************************/
/* conversion flags */
#define SYMTONUM		1	/* convert symbolic to numeric */
#define NUMTOSYM		2	/* convert numeric to symbolic */
#define CVTIPADD		3	/* convert a 32 bit IP address */

strng *sgmp_var_cvt();
char hexcvt();
