/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/******************************************************************************
**
**			umon.h
**
** This file contains the data structures and the type definitions dictated
** by the Gateway Monitoring Protocol. Hence it's contents should
** not be changed lightly.
**
**
*******************************************************************************/
/* type definitions */
typedef struct {				/* definition of a string */
		short	len;			/* length of string, in bytes */
		char *	str;			/* the string */
	       } strng;
typedef struct {
		short	type;			/* type - INTEGER or string */
		union { strng * str;		/* string */
			long intgr;		/* integer (long) */
		      } value;			/* actual value */
	       } var_value_type;

typedef strng *var_name_type;

typedef struct _var_op_type {				
		var_name_type	var_name;	/* variable name */
		var_value_type	var_value;	/* variable value */
		struct _var_op_type *var_next;	/* pointer to rest of list */
		} var_op_type;			/* structure of a variable */

typedef var_op_type *var_op_list_type;		/* list of variables */

typedef long error_status_type;			/* error status */

typedef long error_index_type;			/* error index type */

typedef long request_id_type;			/* type of request id */

typedef struct {
		request_id_type		request_id;	/* request id */
		error_status_type	error_status;	/* return code */
		error_index_type	error_index;	/* to indicate error */
		var_op_list_type	var_op_list;	/* list of variables */
		} get_req_msg_type;		/* to get var value */

typedef get_req_msg_type	set_req_msg_type; /* to set value */

typedef get_req_msg_type	get_rsp_msg_type; /* to get responses */

typedef struct _val_list_type {
		var_value_type		var_op;	/* value of operand */
		struct _val_list_type	*var_next; /* pointer to rest of list */
		} val_list_type;

typedef long trap_type_type;			/* type of trap type */

typedef struct {
		trap_type_type	trap_type;	/* trap type */
		val_list_type	*val_list;	/* list of variables */
		} trap_req_msg_type;	/* to send trap messages */

/* return codes */
#define GMP_ERR_NOERROR			0	/* successful return */
#define GMP_ERR_TOO_BIG			1	/* response too large */
#define GMP_ERR_NIX_NAME		2	/* bad variable name */
#define GMP_ERR_BAD_VALUE		3	/* bad variable value */
#define	GMP_ERR_SET			4	/* illegal to set */

/* trap types */
#define COLD_START			0	/* cold start */
#define WARM_START			1	/* warm start */
#define LINK_FAIL			2	/* link failure */
#define AUTH_FAIL			3	/* authentication failure */
#define EGP_NHBR_LOST			4	/* EGP Neighbor Loss Trap */
#define	LINK_UP				5	/* link up */

/* octal representation of what the message identifiers are */
/* octal representations of other things can be found in X409.h */
#define REQ_MSG				'\141'	/* Get Request Message */
#define RSP_MSG				'\142'	/* Get Response Message */
#define TRP_MSG				'\143'	/* Trap Request Message */
#define SET_MSG				'\144'	/* Set Request Message */
