/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/******************************************************************************
**
**			sgmp.h
**
** This file contains implementation dependent data structures and include
** files whose structure is not specified by the Gateway Monitoring Protocol.
** It is also the 'master include file' which includes all other files
** neccessary.
**
**
*****************************************************************************/
/* the usual includes.. */
#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <ctype.h>
#include <strings.h>
#include <errno.h>

/* for sockets and networking */
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

/* for system stuff - signalling, file manipulation etc. */
#include <signal.h>		/* signals */
#include <sys/file.h>		/* file manipulations */
#include <sys/ioctl.h>		/* ioctls */
#include <setjmp.h>		/* to save/restore process state */
#include <sys/time.h>		/* time, and for reaping dead children */
#include <sys/resource.h>	/* system resources */
#include <sys/wait.h>		/* for forking and execing and ... */

/* for umon protocol specified definitions */
#include "umon.h" 

/* type definitions */
typedef unsigned char *PACKET;			/* the type PACKET */

/* message types - other types can be found in X409.h */
#define GET_REQ_MESG			1	/* Get Request Message */
#define GET_RSP_MESG			2	/* Get Response Message */
#define TRP_REQ_MESG			3	/* Trap Request Message */
#define SET_REQ_MESG			4	/* Set Request Message */

/* other types - message types can be found in sgmp.h */
#define SEQUENCE			5	/* a list */
#define INTEGER				6	/* integer */
#define PRIM_STR			7	/* octet string */
#define CONS_STR			8	/* constructed string */

/* miscellaneous returns */
#define REQID_UNKNOWN   -6              /* unknown request id */
#define AUTHEN_ERR      -5              /* authentication error */
#define SEND_TIMEOUT	-4		/* error in transmission */
#define	GEN_ERR		-3		/* generic error */
#define PARSE_ERROR	-2		/* error in parsing */
#define UNKNOWN_TYPE	-1		/* Unknown type */
#define PARSE_OK	 0	 	/* Parsed successfully */
#define REQ_ANY		 1		/* Any Request Id */
#define AUTHEN_OK        2              /* authentication successful */
#define NEW_ID           3              /* a new req. id to be added */
#define VERIFY_ID        4              /* verify the req. id */

/* constants needed globally */
#define MAXLEN		576	/* maximum length of a packet */

/* function definitions */
extern long dotot32bit();
extern char *stdtodot();
