/*

Copyright 1987 by Rensselaer Polytechnic Institute

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of RPI not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
RPI makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/
/******************************************************************************
**
**			X409.h
**
** Definitions and global variables needed for Simple Gateway Monitoring
** Protocol parser and packet builder
**
**
*****************************************************************************/
/* constants */
#define ISLONG		0200		/* to mask out everything but 8th bit */
#define LENMASK		0177		/* to mask out 8th bit in octet */
#define LONG_LEN	4		/* length in bytes of a long */
#define INDEFINITE	'\200'		/* what indefinite length looks like */
#define ISINDEFINITE	-32767		/* length is indefinite */
#define EOCID		'\0'		/* end of contents id */
#define EOCLEN		'\0'		/* end of contents length */
#define TOO_LONG	129		/* length too long */
#define HEADLEN		8		/* maximum length of a header */
#define CONTLEN		576		/* maximum length of contents */
#define PKT_OVERFLOW	-65535		/* packet too long */

/* types (besides message types) - message types can be found in umon.h */
#define INT_TYP		'\002'		/* id for integer */
#define SEQ_TYP		'\060'		/* a sequence */
#define PRM_STR		'\004'		/* a primitive string */
#define CON_STR		'\044'		/* a constructed string */

/* function types */
extern char * parse_sgmp_pkt();		/* functions from parser */
extern int parse_req_mesg();
extern int parse_trap_mesg();
extern PACKET parse_header();
extern PACKET parse_int();
extern PACKET parse_string();
extern PACKET parse_var_list();
extern PACKET parse_var_type();
extern PACKET parse_value();
extern PACKET parse_val_list();
extern PACKET build_sgmp_pkt();		/* functions from packet builder */
extern PACKET build_req_mesg();
extern PACKET build_trap_mesg();
extern PACKET build_header();
extern PACKET build_value();
extern PACKET build_var_list();
extern PACKET build_var_type();
extern PACKET build_val_list();
extern PACKET build_int();
extern PACKET build_string();
