/***********************************************************
        Copyright 1991 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#ifndef  _COLLECTION_H
#define _COLLECTION_H
static char Collection_rcs_idH[]= "$Header: /afs/andrew.cmu.edu/system/src/local/depot/016/RCS/Collection.h,v 4.3 1992/02/12 18:05:04 ww0r Exp $";

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

/* update specifications in config file for collection */
#define CU_MAP		001
#define CU_RCFILE	002
#define CU_DELETE	004

#ifdef USE_FSINFO
#define CU_AFSMOUNTPOINT 010
#endif USE_FSINFO

extern Boolean Collection_Read();
extern char *Collection_LocatePath();

extern COLLECTIONLIST *CollectionList_GetAllCollections();
extern COLLECTIONLIST *CollectionList_GetCollectionList();
extern COLLECTIONLIST *CollectionList_GetAllKnownCollections();
extern COLLECTIONLIST *CollectionList_GetKnownCollections();
extern void CollectionList_FreeList();
/*
 * $Log: Collection.h,v $
 * Revision 4.3  1992/02/12  18:05:04  ww0r
 * make RCS headers visibile
 * added protection against double includes
 *
 * Revision 4.2  1992/02/03  19:21:02  ww0r
 * added CollectionList_FreeList()
 *
 * Revision 4.1  1991/10/08  21:48:11  dl2n
 * add CMU copyright
 *
 * Revision 4.0  1991/09/25  17:36:20  sohan
 * Release 4
 *
 * Revision 4.0  1991/09/25  16:08:52  sohan
 * Version 4.0
 *
 */

#endif /* COLLECTION_H */
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot/016/RCS/Collection.h,v $ */
