/*This line lets emacs recognize this as -*- C -*- Code
 *-----------------------------------------------------------------------------
 *
 * Project:	Tcl Modules
 * Created:	91/10/23
 * Author:	John L. Furlani<john.furlani@East.Sun.COM>
 *
 * Description:
 *      The main routine of Tcl Modules including all of the global data.
 *	
 * $Log: main.c,v $
 *
 *
 * Revision 1.4  1993/01/25  18:48:13  jlf
 * Changed the method for keeping and unwinding failed modulefiles.
 * The output returns to its optimized state where only the aggregate
 * changes to the environment are sent to the executing shell.
 *
 * Revision 1.3  1993/01/23  01:01:23  jlf
 * Fixed a number of memory leaks and large static arrays.
 *
 * Revision 1.2  1993/01/22  17:37:35  jlf
 * Added purge sub-command.
 *
 * Revision 1.1  1992/11/05  23:25:50  jlf
 * Initial revision
 *
 *---------------------------------------------------------------------------*/
static char Id[] =
    "$Id: main.c,v 2.0 1993/02/21 00:01:18 jlf Exp jlf $";

#include "global.h"

/* Global Vars */
char*       current_module = NULL;
char**      shell_startups;
char        shell_name[20];
char        shell_derelict[20];
int         flags = 0;

regexp* addPtr;
regexp* rmPtr;
regexp* swPtr;
regexp* dispPtr;
regexp* listPtr;
regexp* availPtr;
regexp* helpPtr;
regexp* initPtr;
regexp* usePtr;
regexp* unusePtr;
regexp* updatePtr;
regexp* purgePtr;
regexp* clearPtr;

Tcl_HashTable*  setenvHashTable;
Tcl_HashTable*  unsetenvHashTable;
Tcl_HashTable*  aliasSetHashTable;
Tcl_HashTable*  aliasUnsetHashTable;
Tcl_HashTable*  markVariableHashTable;
Tcl_HashTable*  markAliasHashTable;

char* line = NULL;

int
main(int argc, char* argv[], char* environ[]) {
  Tcl_Interp*  interp;
  int          return_val = 0, saved_stdout;

  Initialize_Tcl(&interp, argc, argv, environ);
  Setup_Environment(interp);

  if(argc < 3) {
    char* helpargv[3];

    fprintf(stderr, "\nUsage:  module sub-command [args]\n");

    helpargv[0] = "module";
    helpargv[1] = "help";
    helpargv[2] = NULL;

    cmdModule((ClientData) 0, interp, 2, helpargv);
    return 1;
  }

  if(argc > 2) {
      return_val = cmdModule((ClientData) 0, interp, (argc - 1), (argv + 1));
      /*
       *  If we were doing some operation that has already flushed its output,
       *  then we don't need to re-flush the output here.
       *
       *  Also, if we've had an error here, then the whole modulecmd failed
       *  and not just the values for a single modulefile.  So, we'll pass in
       *  a NULL here to indicate that any error message should say that
       *  absolutely NO changes were made to the environment.
       */
      if(return_val == TCL_OK) {
          Output_Modulefile_Changes(interp);
#ifdef HAS_X11LIBS
          xresourceFinish(1);
#endif
      } else {
          Unwind_Modulefile_Changes(interp, NULL, NULL);
#ifdef HAS_X11LIBS
          xresourceFinish(0);
#endif
      }
      
      Delete_Global_Hash_Tables();

      if(line) free(line);
  }
  return return_val;
}
