/* $Copyright:	$
 * Copyright (c) 1991,1992,1993 by Steve Baker
 * All rights reserved
 *  
 * This software is provided as is without any express or implied
 * warranties, including, without limitation, the implied warranties
 * of merchantability and fitness for a particular purpose.
 */
#ifdef DEBUG
#include "mem/mem.h"
#endif DEBUG

#include <stdio.h>
#include <signal.h>
#include <ctype.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>

#define BYTE		unsigned char
#define WORD		unsigned short
#define LONG		unsigned long
#define GLOBAL_INIT	"/etc/.sshrc"
#define SHELL_LOGIN	".login"
#define SHELL_INIT	".sshrc"
#define SHELL_EXIT	".logout"
#define HIST_SAVE	".hist"
#define SECOND_PASS	".second"
#define WARNING		".warning"
#define NULL_DEV	"/dev/null"

#define SHELL_COMMAND	1
#define NORMAL_COMMAND	0
#define TTY		0
#define TRUE		1
#define FALSE		0

#define ERR_NO_USER	1
#define ERR_NO_MATCH	2
#define ERR_BREAK	-1
#define ERR_CONTINUE	-2
#define ERR_GOTO	-3
#define ERR_EXIT	-4

#define RET_MASK	0x00FF
#define TERM_MASK	0xFF00

#ifndef sigmask
#define sigmask(x)	(1<<(x))
#endif

#define calloc(x,y)	malloc((x)*(y))
#define	_ret(x)		((x)&RET_MASK)
#define _trm(x)		(((x)&TERM_MASK)>>8)
#define badstat(x)	((x) && ((_ret(x)>=_failat) || (_trm(x) && (SIGMASK&sigmask(_trm(x))))))
#define SCOPY(x)	((char *)strcpy((char *)malloc(strlen(x)+1),(x)))

enum {SO,SE,CE,KS,KE,DC,IC,DS,TS,FS,HS};

#define T_STRING	0
#define T_INTEGER	1
#define T_NULL		2

union setval {
  long val;
  char **wrd;
};

struct _setvar {
  char *var;
  struct _setvar *nxt;
  union setval sv;
  WORD nwrds;
  BYTE protect : 1;	/* 1 = Cannot change or remove this variable */
  BYTE type    : 2;	/* 0 = string, 1 = numeric, 2 = null var */
};

struct _alias {
  char *cmd;
  char **wrd;
  struct _alias *nxt;
};

struct _proc {
  char *name;
  char ***cmd;
  struct _proc *nxt;
};

#define MAX_GLVL	10
struct custom_keys {
  char *key;
  char *cmd;
  BYTE clr  : 1;	/* clear line? */
  BYTE rtn  : 1;	/* auto-execute line? */
  BYTE gold : 1;	/* gold key? */
  BYTE glvl : 4;	/* level that gold key goes to */
  BYTE func : 5;	/* function key? */
};

#define STAT_RUNNING	0

struct proc_tab {
  char *cmd;
  WORD pid;
  WORD pgrp;
  WORD pipe;
  BYTE status : 7;
  BYTE bg     : 1;
};

struct dirent {
  struct dirent *next;
  char *entry;
};

#ifdef CANNOT_ALLOCA
#define ALLOCA(x)   malloc(x)
#define FREEA(x)    free(x)
#else CAN_ALLOCA
#define ALLOCA(x)   alloca(x)
#define FREEA(x)    /* automatically freed */
#endif CAN_ALLOCA

#define MAX_FILES	10

struct _FILES {
  char *name;
  char *file;
  BYTE read : 1;
  BYTE write : 1;
  BYTE ispipe : 1;
  BYTE pread : 1;	/* Pipes need to have only one writer period */
  BYTE pwrite : 1;
  char pipe;	/* Temp for pipes */
  char desc;
};
