/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * uReap.c -- Provides an asynchronous die facility.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Fri Feb  9 15:29:24 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:26:12 1990
 * Update Count     : 7
 */

#include <uSystem.h>
#include <uReap.h>

static uTask uReapTask = NULL;
static uSemaphore uFirst = U_SEMAPHORE( 1 );

static void uReap() {

    uTask client;

    for ( ;; ) {
	client = uReceive( NULL, 0 );
	uReply( client, NULL, 0 );
	uAbsorb( client, NULL, 0 );
    } /* for */

} /* uReap */

static void uInitDieAlone() {

    uReapTask = uEmit( uReap );

} /* uInitDieAlone */

void uDieAlone() {

    uP( &uFirst );
    if ( uReapTask == NULL ) {
	uInitDieAlone();
    } /* if */
    uV( &uFirst );
    
    uSend( uReapTask, NULL, 0, NULL, 0 );
    uDie( NULL, 0 );

} /* uDieAlone */

/* Local Variables: */
/* compile-command: "dmake" */
/* End: */
