/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * stdarg-mips.h -- simulate variable arguments
 * 
 * Author           : Richard A. Stroobosscher
 * Created On       : Tue May  8 13:31:57 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:26:57 1990
 * Update Count     : 7
 */

#ifndef _VA_LIST_
#define _VA_LIST_
typedef char *va_list;
#endif /* !_VA_LIST_ */

#define va_start(list, parmN) (va_save(), list = \
	(char *) (sizeof(parmN) > 4 ? ((int)&parmN + 2*8 - 1) & -8 \
				    : ((int)&parmN + 2*4 - 1) & -4))

#define va_arg(list, mode) ((mode *)(list = \
	(char *) (sizeof(mode) > 4 ? ((int)list + 2*8 - 1) & -8 \
				   : ((int)list + 2*4 - 1) & -4)))[-1]

#define va_end(list)

static inline void va_save() {
    asm volatile ( "sw $4, 0($30)" );
    asm volatile ( "sw $5, 4($30)" );
    asm volatile ( "sw $6, 8($30)" );
    asm volatile ( "sw $7, 12($30)" );
}
