/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * uSampler.h -- Declarations of uSampler package.
 * 
 * Author           : Peter Buhr
 * Created On       : Fri Feb  9 15:31:12 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:27:02 1990
 * Update Count     : 9
 */

#ifndef __U_SAMPLERH__
#define __U_SAMPLERH__

/*
 * When compiling with a C++ compiler, make all these
 * declarations appear as C declarations to the C++ compiler.
 */

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
    int time;
    int TargetVal[0];
} uSample;

typedef struct uSamplerStruct {
    uCluster Cluster;
    uTask task;
    uSemaphore start;
    int NoOfSamples;
    int Frequency;
    int NoOfTargets;
    uSample *Samples;
    int *Targets[0];
} *uSampler;

uSampler uCreateSampler( int, int, int *, ... );
void uStartSampler( uSampler );
void uDestroySampler( uSampler, uStream );

/*
 * Close the C++ wrapper.
 */
    
#ifdef __cplusplus
}
#endif

#endif /* __U_SAMPLERH__ */
