/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * md-vax.i -- Machine dependent uKernel code.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Thu Mar 15 10:48:44 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:30:41 1990
 * Update Count     : 16
 */

static inline void uCopy( void *src, void *dst, unsigned int len ) {

    /*
     * This assembly language instruction will copy a maximum
     * of 64K bytes.  If this is not sufficient, replace this
     * line with a call to the function bcopy().
     */

    asm volatile ( "movc3 %0, (%1), (%2)" : : "g" (len), "r" (src), "r" (dst) : "r0", "r1", "r2", "r3", "r4", "r5" );
} /* uCopy */

static inline void *uReadStackPointer( void ) {

    void *addr;

    asm volatile ( "movl sp, %0" : "=g" (addr) );
    return( addr );
} /* uReadStackPointer */

static inline void uWriteStackPointer( void *addr ) {
    asm volatile ( "movl %0, sp" : : "g" (addr) : "sp" );
} /* uWriteStackPointer */

static inline void *uReadFramePointer( void ) {

    void *addr;

    asm volatile ( "movl fp, %0" : "=g" (addr) );
    return( addr );
} /* uReadFramePointer */

static inline void uWriteFramePointer( void *addr ) {
    asm volatile ( "movl %0, fp" : : "g" (addr) : "fp" );
} /* uWriteFramePointer */

static inline void *uReadReturnAddress( void ) {

    void *addr;

    asm volatile ( "movl -4(ap), %0" : "=g" (addr) );
    return( addr );
} /* uReadReturnAddress */

static inline void uWriteReturnAddress( void *addr ) {
} /* uWriteReturnAddress */

static inline void uCallUsingStack( void (*begin)() ) {
    (*begin)();
} /* uCallUsingStack */

static inline void uMakeFrameUsingStack( uStack stack, void *buf, int len ) {
    stack->fp = stack->base;
    stack->sp = stack->fp - U_CEILING( len, sizeof( double ) );
    uCopy( buf, stack->sp, len );
} /* uMakeFrameUsingStack */
    
static inline void uPushFixedRegs( void ) {

    /*
     * Save only those registers that the GCC machine
     * configuration files specify as being saved across
     * functions calls.
     */
    
    asm volatile ( "pushr $0x2fc0" );
} /* uPushFixedRegs */

static inline void uPopFixedRegs( void ) {

    /*
     * Restore the saved registers.
     */
    
    asm volatile ( "popr $0x2fc0" );
} /* uPopFixedRegs */

static inline void uPushFloatRegs( void ) {
} /* uPushFloatRegs */

static inline void uPopFloatRegs( void ) {
} /* uPopFloatRegs */

static inline void uSaveContext( register unsigned long* context ) {

    /*
     * must save frame pointer,
     *           stack pointer,
     *           instruction pointer,
     *           and registers which must be saved across procedure calls.
     */

    asm volatile ( "movl -8(ap), %0"  : "=m" (context[0]) );	      /* save old frame pointer */
    asm volatile ( "mull3 (ap), $4, r1" ::: "r1" );
    asm volatile ( "addl3 ap, r1, %0" : "=m" (context[1]) );	      /* sp to restore */
    asm volatile ( "movl -4(ap), %0" : "=m" (context[2]) );	      /* return address */
    asm volatile ( "movl r6, %0" : "=m" (context[3]) );		      /* save registers */
    asm volatile ( "movl r7, %0" : "=m" (context[4]) );
    asm volatile ( "movl r8, %0" : "=m" (context[5]) );
    asm volatile ( "movl r9, %0" : "=m" (context[6]) );
    asm volatile ( "movl r10, %0" : "=m" (context[7]) );
    asm volatile ( "movl r11, %0" : "=m" (context[8]) );
} /* uSaveContext */

static inline void uRestoreContext( register unsigned long* context ) {

    /*
     * must restore frame pointer,
     *           stack pointer,
     *           and registers which must be saved across procedure calls.
     * the non-zero return value is setup, 
     * followed by a jump to the return address
     */

    asm volatile ( "movl %0, fp" :: "m" (context[0]) : "fp" );	      /* restore frame pointer */
    asm volatile ( "movl %0, sp" :: "m" (context[1]) : "sp" );	      /* restore stack pointer */
    asm volatile ( "movl %0, r6" :: "m" (context[3]) : "r6" );	      /* restore registers */
    asm volatile ( "movl %0, r7" :: "m" (context[4]) : "r7" );
    asm volatile ( "movl %0, r8" :: "m" (context[5]) : "r8" );
    asm volatile ( "movl %0, r9" :: "m" (context[6]) : "r9" );
    asm volatile ( "movl %0, r10" :: "m" (context[7]) : "r10" );
    asm volatile ( "movl %0, r11" :: "m" (context[8]) : "r11" );
    asm volatile ( "movl %0, r1" :: "m" (context[2]) : "r1" );	      /* get return address */
    asm volatile ( "movl $1, r0" ::: "r0" );			      /* setup result */
    asm volatile ( "jmp (r1)" );				      /* jump back */
} /* uRestoreContext */
