/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * md-m68k.i -- Machine dependent code for the uKernel.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Thu Mar 15 10:46:04 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:30:38 1990
 * Update Count     : 15
 */

static inline void uCopy( void *src, void *dst, unsigned int len ) {
    bcopy( src, dst, len );
} /* uCopy */

static inline void *uReadStackPointer( void ) {

    void *addr;

    asm volatile ( "movel sp, %0" : "=g" (addr) );
    return( addr );
} /* uReadStackPointer */

static inline void uWriteStackPointer( void *addr ) {
    asm volatile ( "movel %0, sp" : : "g" (addr) : "sp" );
} /* uWriteStackPointer */

static inline void *uReadFramePointer( void ) {

    void *addr;

    asm volatile ( "movel a6, %0" : "=g" (addr) );
    return( addr );
} /* uReadFramePointer */

static inline void uWriteFramePointer( void *addr ) {
    asm volatile ( "movel %0, a6" : : "g" (addr) : "a6" );
} /* uWriteFramePointer */

static inline void *uReadReturnAddress( void ) {

    void *addr;

    asm volatile ( "movel a6@(4), %0" : "=g" (addr) );
    return( addr );
} /* uReadReturnAddress */

static inline void uWriteReturnAddress( void *addr ) {
} /* uWriteReturnAddress */

static inline void uCallUsingStack( void (*begin)() ) {
    (*begin)();
} /* uCallUsingStack */

static inline void uMakeFrameUsingStack( uStack stack, void *buf, int len ) {
    stack->fp = stack->base;
    stack->sp = stack->fp - U_CEILING( len, sizeof( double ) );
    uCopy( buf, stack->sp, len );
} /* uMakeFrameUsingStack */
    
static inline void uPushFixedRegs( void ) {

    /*
     * Save only those registers that the GCC machine
     * configuration files specify as being saved across
     * functions calls.
     */
    
    asm volatile ( "moveml #0x3f3e, sp@-" );
} /* uPushFixedRegs */

static inline void uPopFixedRegs( void ) {

    /*
     * Restore the saved registers.
     * Notice that the register mask is the reverse of
     * what was used to save the registers.
     */
    
    asm volatile ( "moveml sp@+, #0x7cfc" );
} /* uPopFixedRegs */

static inline void uPushFloatRegs( void ) {

    /*
     * Save only those registers that the GCC machine
     * configuration files specify as being saved across
     * functions calls.
     */
    
    asm volatile ( "fmovem #0xff, sp@-" );
} /* uPushFloatRegs */

static inline void uPopFloatRegs( void ) {

    /*
     * Restore the saved registers.
     */
    
    asm volatile ( "fmovem sp@+, #0xff" );
} /* uPopFloatRegs */

static inline void uSaveContext( register unsigned long* context ) {

    /*
     * must save frame pointer,
     *           stack pointer,
     *           instruction pointer,
     *           and registers which must be saved across procedure calls.
     */

    asm volatile ( "movel a6@, %0"  : "=m" (context[0]) );	      /* save old frame pointer */
    asm volatile ( "lea   a6@(4), a1" : : : "a1"  );		      /* sp to restore */
    asm volatile ( "movel a1, %0"    : "=m" (context[1]) );
    asm volatile ( "movel a6@(4), %0" : "=m" (context[2]) );	      /* return address */
    asm volatile ( "moveml #0x3cfc, %0" : "=m" (context[3]) );	      /* save registers */
} /* uSaveContext */

static inline void uRestoreContext( register unsigned long* context ) {

    /*
     * must restore frame pointer,
     *           stack pointer,
     *           and registers which must be saved across procedure calls.
     * the non-zero return value is setup, 
     * followed by a jump to the return address
     */

    asm volatile ( "movel %0, a6" : : "m" (context[0]) : "a6" );     /* restore frame pointer */
    asm volatile ( "movel %0, sp" : : "m" (context[1]) : "sp" );     /* restore stack pointer */
    asm volatile ( "moveml %0, #0x3cfc" : : "m" (context[3]) :
		    "a2", "a3", "a4", "a5",
		    "d2", "d3", "d4", "d5", "d6", "d7" );             /* restore registers */
    asm volatile ( "movel %0, a1" : : "m" (context[2]) : "a1" );      /* get return address */
    asm volatile ( "moveq #1, d0" : : : "d0" );			      /* setup result */
    asm volatile ( "jmp a1@" );					      /* jump back */
} /* uRestoreContext */
