/* imagen PQuickSort.c columns=2 Tabstops=8 +Headings -Compress +Landscape +Outline */

#include <uSystem.h>

/* Standard quick sort creating a new process for each partitioning of the data values.
   Because each partition is independent of all other partitions, no concurrency control
   is necessary.
   */

void PQuick( int values[], int LowerBound, int UpperBound ) {
    int lb, ub, pivot, space, less, greater;
    uTask Left, Right;
    
    pivot = values[LowerBound];
    space = LowerBound;
    lb = LowerBound + 1;
    ub = UpperBound;

    for (;;) {
	for ( less = ub; lb <= less; less -= 1 ) {	/* from the right, any value less than pivot ? */
	if ( values[less] < pivot ) {
		values[space] = values[less];		/* move to free space */
		space = less;				/* remember new space */
		break;
	    } /* exit */
	} /* for */
	
	ub = less - 1;

    if ( lb > ub ) break;				/* finished movement ? */

	for ( greater = lb; greater <= ub; greater += 1 ) { /* from the left, any value greater than pivot ? */
	if ( pivot < values[greater] ) {
		values[space] = values[greater];	/* move to free space */
		space = greater;			/* remember new space */
		break;
	    } /* exit */
	} /* for */
	
	lb = greater + 1;

    } /* for */
    
    values[space] = pivot;				/* re-insert the pivot value */

    /* start both partitions to get some concurrency and then wait for their completion */
    
    Left = Right = NULL;
    if ( LowerBound < space - 1 ) 
	Left = uEmit( PQuick, values, LowerBound, space - 1 ); /* clone myself to sort the lesser values */
    if ( space + 1 < UpperBound )
	Right = uEmit( PQuick, values, space + 1, UpperBound ); /* clone myself to sort the greater values */

    if ( Left  != NULL ) uAbsorb(Left, NULL, 0);
    if ( Right != NULL ) uAbsorb(Right, NULL, 0);

    uDie( NULL, 0 );
} /* PQuick */

#define NOOFVALUES 13

void uMain() {
    /* int TestValues[] = { 399, 110, 461, 937, 161, 689, 489, 953, 373, 231, 395, 287,484 }; */
    int TestValues[] = { 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1 };
    int i;

    uPrintf( "values:\n");
    for ( i = 0; i < NOOFVALUES - 1; i += 1 ) {
	uPrintf( "%d, ", TestValues[i] );
    } /* for */
    uPrintf( "%d\n", TestValues[NOOFVALUES - 1] );
    
    uAbsorb( uEmit( PQuick, TestValues, 0, NOOFVALUES - 1 ), NULL, 0 );	/* sort values */
    
    uPrintf( "sorted values:\n" );
    for ( i = 0; i < NOOFVALUES - 1; i += 1 ) {
	uPrintf( "%d, ", TestValues[i] );
    } /* for */
    uPrintf( "%d\n", TestValues[NOOFVALUES - 1] );
    
    uPrintf( "successful completion\n" );
} /* uMain */
