/* Copyright (c) 1989  P. A. Buhr */

/*
  Cigarette Smokers Problem (Pati 1971)
  
  Consider a system with 3 smoker processes and one agent process.
  Each smoker continuously makes a cigarette and smokes it. But to
  make a cigarette, 3 ingredients are needed: paper, tobacco & matches.
  One smoker has an infinite supply of paper, another an infinite supply
  of tobacco and the third an infinite supply of matches. The agent
  has an infinite supply of all three supplies. The agent offers each
  of the smokers 2 ingredients. The smoker who has the remaining
  ingredient takes the agent's ingredients, makes a cigarette, smokes it
  and signals the agent upon completion. The agent then puts out another
  2 of the 3 ingredients and the cycle repeats. The cycle ends when the
  agent offers no ingredients.
  
  A queue of length 1 is used between the Sender and Receiver.
  */

#include <uSystem.h>

long random( void );
void exit( int );

#define ElemType int
#define QueueSize 1					/* queue size for talk and listen */
#include "TalkListen.c"

#define PAPER 03
#define TOBACCO 05
#define MATCHES 06
#define NOSUPPLIES ( PAPER | TOBACCO | MATCHES )
    
char *Titles[7];

void Smoker( int Supply, struct medium *Medium, struct medium *AgentMedium ) {
    int supplies;
    
    for ( ;; ) {
	supplies = listen( Medium );			/* get supplies */
    if ( supplies == NOSUPPLIES ) break;		/* any supplies ? */
	if ( supplies == ( ( ~Supply ) & 07 ) ) {	/* paper & matches ? */
	    uPrintf( "%s found %s\n\n", Titles[Supply], Titles[supplies] );
	    talk( AgentMedium, Supply );
	} /* if */
    } /* for */
    uDie( NULL, 0 );
} /* Smoker */

int TwoBitsOff[3] = { PAPER & TOBACCO, PAPER & MATCHES, TOBACCO & MATCHES };

void Agent( struct medium *PaperMedium, struct medium *TobaccoMedium, struct medium *MatchesMedium, struct medium *AgentMedium ) {
    int supplies, reply, i;
    
    for ( i = 1; i <= 20; i += 1 ) {
	/* generate 2 of the 3 supplies */
	
	supplies = TwoBitsOff[random(  ) % 3];
	
	/* send supplies to smokers */
	
	uPrintf( "Agent supplies %s\n", Titles[supplies] );
	talk( PaperMedium, supplies );
	talk( TobaccoMedium, supplies );
	talk( MatchesMedium, supplies );
	
	/* listen for response, and check if correct */
	
	reply = listen( AgentMedium );
    if ( ( reply & supplies ) != ( PAPER & TOBACCO & MATCHES ) ) { /* correct user of supplies ? */
	    uPrintf( "incorrect user of supplies\n" );
	    exit( -1 );
	} /* if */
    } /* for */
    talk( PaperMedium, NOSUPPLIES );
    talk( TobaccoMedium, NOSUPPLIES );
    talk( MatchesMedium, NOSUPPLIES );
    uDie( NULL, 0 );
} /* Agent */

void uMain( ) {
    uTask PaperId, TobaccoId, MatchesId, AgentId;
    struct medium PaperMedium, TobaccoMedium, MatchesMedium, AgentMedium;
    
    Titles[PAPER] = "Paper";
    Titles[TOBACCO] = "Tobacco";
    Titles[MATCHES] = "Matches";
    Titles[PAPER & TOBACCO] = "paper & tobacco";
    Titles[PAPER & MATCHES] = "paper & matches";
    Titles[TOBACCO & MATCHES] = "tobacco & matches";
    Titles[PAPER & TOBACCO & MATCHES] = "paper & tobacco & matches";
    
    /* initialize communication medium */
    
    initmedium( &PaperMedium );
    initmedium( &TobaccoMedium );
    initmedium( &MatchesMedium );
    initmedium( &AgentMedium );
    
    PaperId = uEmit( Smoker, PAPER, &PaperMedium, &AgentMedium );
    TobaccoId = uEmit( Smoker, TOBACCO, &TobaccoMedium, &AgentMedium );
    MatchesId = uEmit( Smoker, MATCHES, &MatchesMedium, &AgentMedium );
    AgentId = uEmit( Agent, &PaperMedium, &TobaccoMedium, &MatchesMedium, &AgentMedium );
    
    uAbsorb( PaperId, NULL, 0 );
    uAbsorb( TobaccoId, NULL, 0 );
    uAbsorb( MatchesId, NULL, 0 );
    uAbsorb( AgentId, NULL, 0 );
    uPrintf( "successful completion\n" );
} /* uMain */
