/* Copyright (c) 1989  P. A. Buhr */

/*
  Method: G. L. Peterson's algorithm: Simplify Dekker's algorithm by not
    explicitly alternating on simultaneous entry to the critical
    section. Instead use the fact that even if 2 processes are executing
    synchronously and hence assigning to the same variable at
    the same time, only one of the values ends up in variable.
    Whichever process's value does NOT end up in the variable will
    be given priority as that process passed through 1st. In general,
    this is fair because each process has an equal chance of its value
    being assigned to the variable.
  Work?: YES
*/

#include <uSystem.h>

#define WantIn 1
#define DontWantIn 0

int *Last;						/* shared between processes */

void GLPeterson(int *me, int *other) {
    int i;						/* loop counter */

    for (i = 1; i <= 1000; i += 1) {			/* exercise critical section */

        /* entry protocol */

        *me = WantIn;					/* declare intent */
        Last = me;					/* race to see who's value is assigned */
        while (*other == WantIn && Last == me) {}	/* busy wait for loser */
    
        /* critical section */
    
        CriticalSection();

        /* exit protocol */

        *me = DontWantIn;				/* declare not interested */
    } /* for */

    uDie(NULL, 0);
} /* GLPeterson */

void uMain() {
    uTask t0, t1;
    int me, other;					/* shared between processes */
 
    uSetTimeSlice(10);
    
    me = other = DontWantIn;
    t0 = uEmit(GLPeterson, &me, &other);		/* start process */
    t1 = uEmit(GLPeterson, &other, &me);		/* start process */
 
    uAbsorb(t0, NULL, 0);				/* wait for completion of process */
    uAbsorb(t1, NULL, 0);				/* wait for completion of process */
    uPrintf("successful execution\n");
} /* uMain */
