/* Copyright (c) 1989  P. A. Buhr */

/*
  This critical section does nothing except constantly check that
  no one else has entered or completely passed through the critical
  section. This is accomplished by storing the process id of the 
  current process in an external variable and then checking that it
  remains the same during the execution of the critical section. 
  If any other process enters the critical section, it will immediately
  change the value of the external variable. When the other process
  resumes, it will notice the change.
  */

#include <uSystem.h>

uTask CurrPid;						/* current process id */

CriticalSection() {
    int i;
    
    CurrPid = uThisTask();					/* copy process id */
    
    for (i = 1; i <= 100; i += 1) {			/* busy delay */
        if (CurrPid != uThisTask()) {			/* check if another process was in the critical section */
            uError("interference\n");
        } /* if */
    } /* for */
} /* CriticalSection */
