/*
  There are two classes of processes, class A and class B.  Processes of class A
  are allowed concurrent execution in the critical section; similarly, processes
  of class B are allowed concurrent execution in the critical section.  However,
  no process of class A is allowed to execute the critical section concurrently
  with a process of class B.
  */

#include <uMonitor.h>

uMonitor {
    int AsCount = 0, BsCount = 0;
    uCondition As = U_CONDITION, Bs = U_CONDITION;

    uEntry void StartAs( void ) {
	if ( BsCount != 0 || uCondLength( &Bs ) != 0 ) {
	    uWait As;
	} /* if */
	AsCount += 1;
	uSignal As;
    } /* StartAs */

    uEntry void EndAs( void ) {
	AsCount -= 1;
	if ( AsCount == 0 ) {				/* last A user ? */
	    uSignal Bs;
	} /* if */
    } /* EndAs */

    uEntry void StartBs( void ) {
	if ( AsCount != 0 || uCondLength( &As ) != 0 ) {
	    uWait Bs;
	} /* if */
	BsCount += 1;
	uSignal Bs;
    } /* StartBs */

    uEntry void EndBs( void ) {
	BsCount -= 1;
	if ( BsCount == 0 ) {				/* last B user ? */
	    uSignal As;
	} /* if */
    } /* EndBs */
}
    
void A( void ) {
    uDelay( random() % 20 );				/* don't all start at once */
    StartAs();
    uPrintf( "As:%8x, no. of concurrent As:%2d, no. of Bs:%2d\n", uThisTask(), AsCount, BsCount );
    uDelay( random() % 5 );				/* let some others join the party */
    EndAs();
    uDie( NULL, 0 );
} /* A */

void B( void ) {
    uDelay( random() % 20 );				/* don't all start at once */
    StartBs();
    uPrintf( "Bs:%8x, no. of concurrent Bs:%2d, no. of As:%2d\n", uThisTask(), BsCount, AsCount );
    uDelay( random() % 5 );				/* let some others join the party */
    EndBs();
    uDie( NULL, 0 );
} /* B */

#define NoOfAs 30
#define NoOfBs 40

void uMain() {
    int i;
    uTask PidAs[NoOfAs], PidBs[NoOfBs];
    
    for ( i = 0; i < NoOfAs; i += 1 ) {			/* create the As */
	PidAs[i] = uEmit( A );
    } /* for */

    for ( i = 0; i < NoOfBs; i += 1 ) {			/* create the Bs */
	PidBs[i] = uEmit( B );
    } /* for */
    
    for ( i = 0; i < NoOfAs; i += 1 ) {			/* wait for As to finish */
	uAbsorb( PidAs[i], NULL, 0 );
    } /* for */
    
    for ( i = 0; i < NoOfBs; i += 1 ) {			/* wait for Bs to finish */
	uAbsorb( PidBs[i], NULL, 0 );
    } /* for */
    
    uPrintf( "successful completion\n" );
} /* uMain */
