/*  Producer-consumer problem with send/receive/reply communication.  */

#include <uSystem.h>

long random( void );

void Producer( uTask Cons, int NoOfItems ) {
    int i, product;
    
    uPrintf( "Producer will produce %d items for the consumer\n", NoOfItems );
    
    for ( i = 1; i <= NoOfItems; i += 1 ) {
        product = random() % 100 + 1;
        uPrintf( " Producer: %2d\n", product );
        uSend( Cons, NULL, 0, &product, sizeof(product) );
    } /* for */
    product = -1;					/* terminal value */
    uSend( Cons, NULL, 0, &product, sizeof(product) );	/* terminate consumer */
    uDie( NULL, 0 );
} /* Producer */

void Consumer( void ) {
    int product;
    
    for ( ;; ) {
        uReply( uReceive( &product, sizeof(product) ), NULL, 0 );
      if ( product < 0 ) break;
        uPrintf( "Consumer : %2d\n", product );
    } /* for */
    uDie( NULL, 0 );
} /* Consumer */

void uMain( ) {
    uTask Prod, Cons;
    
    Cons = uEmit( Consumer );				/* create consumer */
    Prod = uEmit( Producer, Cons, 10 );			/* create producer */
    
    uAbsorb( Prod, NULL, 0 );				/* wait for completion */
    uAbsorb( Cons, NULL, 0 );

    uPrintf( "successful completion\n" );
} /* uMain */
