/* Recursive factorial written in the actor style */

#include <uSystem.h>

struct CustInfo {
    int n;
    uTask u;
};

void RecCustomer( int n, uTask u ) {			/* acquaintance an integer n and and a customer u */
    int k, temp;
    uTask r;

    r = uReceive( &k, sizeof( k ) );			/* let communication be an integer k */
    uReply( r, NULL, 0 );
    temp = n * k;
    uSend( u, 0, 0, &temp, sizeof( temp ) );		/* send [n * k] to u */
    uDie( NULL, 0 );
} /* RecCustomer */

void RecFactorial( ) {					/* acquaintance with self */
    struct CustInfo ci;
    uTask r;

    r = uReceive( &ci, sizeof( ci ) );			/* let communication be an integer n and a customer u */
    uReply( r, NULL, 0 );
    if ( ci.n == 0 ) {
	int n = 1;
	uSend( ci.u, NULL, 0, &n, sizeof( n ) );
    } else {
	struct CustInfo temp;
	uTask c, fp;

	c = uEmit( RecCustomer, ci.n, ci.u );		/*  RecCustomer with acquaintance n and u */
	temp.n = ci.n - 1;
	temp.u = c;
	fp = uEmit( RecFactorial );			/* become RecFactorial */
	uSend( fp, NULL, 0, &temp, sizeof( temp ) );	/* send [n - 1, mailaddress of c] to self */
	uAbsorb( c, NULL, 0 );
	uAbsorb( fp, NULL, 0 );
    } /* if */
    uDie( NULL, 0 );
} /* RecFactorial */

void uMain( ) {
    int status, fact;
    struct CustInfo temp;
    uTask c, fp, r;

    for ( ;; ) {
	uPrintf( "value:" );
	status = uScanf( "%d", &temp.n );
	if ( status == EOF ) break;
	c = uEmit( RecCustomer, 1, uThisTask() );	/* dummy RecCustomer to get result */
	temp.u = c;
	fp = uEmit( RecFactorial );			/* fp = new RecFactorial  */
	uSend( fp, NULL, 0, &temp, sizeof( temp ) );
	r = uReceive( &fact, sizeof( fact ) );
	uReply( r, NULL, 0 );
	uAbsorb( c, NULL, 0 );
	uAbsorb( fp, NULL, 0 );
	uPrintf("%d! = %d\n", temp.n, fact );
    } /* for */
    uPrintf( "\n");
} /* uMain */
