#include <uSystem.h>
#include <uFile.h>
#include <sys/socket.h>
#include <sys/un.h>

void uMain( int argc, char **argv ) {

    int c;
    uFile sd;
    uFile fd;
    struct sockaddr_un server;
    void strcpy( char *, char * );

    switch ( argc ) {
      case 2:
        break;
      default:
        uError( "usage: %s socket-name\n", argv[0] );
        break;
    } /* switch */

    sd = uSocket( AF_UNIX, SOCK_STREAM, 0 );

    server.sun_family = AF_UNIX;
    strcpy( server.sun_path, argv[1] );
    uBind( sd, &server, sizeof( server ) );

    uListen( sd, 5 );

    for ( ;; ) {
        fd = uAccept( sd, 0, 0 );			/* accept a connection */
        for ( ;; ) {
            uRead( fd, &c, sizeof( c ) );		/* read byte from socket */
            uWrite( fd, &c, sizeof( c ) );		/* write byte to socket */
          if ( c == EOF ) break;			/* no bytes left? */
        } /* for */
        uClose( fd );					/* close the connection */
    } /* for */
} /* uMain */

/* Local Variables: */
/* compile-command: "concc -quiet -work -unixrc -multi -O -o Server SocketServer.c" */
/* End: */
