/* Copyright (c) 1989  P. A. Buhr */

/*
  Play a game of cards. The game consists of each player taking a
  number of cards from a deck and passing the deck to the player on
  the left. A player must take at least one card and no more then
  a certain maximum. The player that takes the last cards is the
  winner.
  */

#include <uSystem.h>

long random();
void printf( char *, ... );

int RandBetween(int low, int high) {
    return(random() % (high - low + 1) + low);
} /* RandBetween */

#define MinCardsTaken 1
#define MaxCardsTaken 3

int MakePlay(int RemainingCards) {
    int passing, took;
    
    if (RemainingCards <= MaxCardsTaken) {
	took = RemainingCards;
	passing = 0;
    } else {
	took = RandBetween(MinCardsTaken, MaxCardsTaken); /* random no. between MinCardsTaken & MaxCardsTaken */
	passing = RemainingCards - took;
    } /* if */
    printf("player:%x took %2d cards from the dealer, keep %2d, and passed %2d back to the dealer\n", uThisCoroutine(), RemainingCards, took, passing);
    return(passing);
} /* MakePlay */

void player(int NoOfPlayers, int NoOfCards) {
    int RemainingCards;
    
    for (;;) {
	uSuspend(&RemainingCards, sizeof(RemainingCards), &RemainingCards, sizeof(RemainingCards));	/* wait until given cards by the dealer */
	if (RemainingCards == 0) break;			/* end of game ? */
	RemainingCards = MakePlay(RemainingCards);	/* make a play */
	if (RemainingCards == 0) {			/* did I win ? */
	    printf("player:%x WON\n", uThisCoroutine());
	} /* if */
    } /* for */
} /* player */

#define MaxNoPlayers 8
#define MaxNoGames 5
#define MinNoCards 20
#define MaxNoCards 40

void uMain() {
    uCoroutine players[MaxNoPlayers];
    int NoOfGames, NoOfPlayers, NoOfCards;
    int i, j, Zero = 0, Dummy;
    
    for (NoOfGames = 1; NoOfGames <= MaxNoGames; NoOfGames += 1) {
	NoOfPlayers = RandBetween(2, MaxNoPlayers);	/* random no. between 2 & MaxNoPlayers */
	printf("The number of players is:%d\n", NoOfPlayers);
	
	NoOfCards = RandBetween(MinNoCards, MaxNoCards); /* random no. between MinNoCards & MaxNoCards */
	printf("The number of cards is:%d\n\n", NoOfCards);
	
	for (i = 0; i < NoOfPlayers; i += 1) {
	    players[i] = uCocall(&Dummy, sizeof(Dummy), player, NoOfPlayers, NoOfCards); /* create players */
	} /* for */
	
	for (i = 0; NoOfCards != 0; i = (i + 1) % NoOfPlayers) {
	    uResume(players[i], &NoOfCards, sizeof(NoOfCards), &NoOfCards, sizeof(NoOfCards));	/* pass cards to & from each player */
	} /* for */
	
	for (j = i; j != i - 1; j = (j + 1) % NoOfPlayers) {
	    uResume(players[j], NULL, 0, &Zero, sizeof(Zero)); /* notify the players that the game is over */
	} /* for */
	printf("\nEnd of Game:%d\n\n\n", NoOfGames);	/* whitespace between games */
    } /* for */
    printf("successful completion\n");
} /* uMain */
