/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * sim.c -- This program performs a benchmark test on the concurrency facilities
 *    of the multiprocessor uSystem. It will run on the BSD and System V OSs.
 * 
 * Author           : Peter A. Buhr
 * Created On       : Thu Nov  8 07:56:44 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:24:43 1990
 * Update Count     : 18
 */

#include <uSystem.h>
#include "calibrate.h"

void Worker( int NoWorkers, int PerWorker, int Extra ) {
    int i, j;
    int leftworkers, rightworkers, work, extrawork;
    uTask LeftWorker, RightWorker;

    work = PerWorker;
    if ( Extra > 0 ) {					/* if there are still extras, take one */
	Extra -= 1;
	work += 1;
    } /* if */
    NoWorkers -= 1;					/* take a worker */
    if ( NoWorkers > 0 ) {				/* create siblings */
	leftworkers = NoWorkers / 2;
	extrawork = Extra / 2;
	if ( leftworkers != 0 ) {
	    LeftWorker = uEmit( Worker, leftworkers, PerWorker, extrawork );
	} /* if */
	rightworkers = NoWorkers - leftworkers;
	extrawork = Extra - extrawork;
	RightWorker = uEmit( Worker, rightworkers, PerWorker, extrawork );
    } /* if */

    for ( i = 1; i <= work; i += 1 ) {
	for ( j = 1; j <= ITERATIONS_FOR_100USECS; j += 1 ) { /* 0.1 millisecond loop */
	} /* for */
    } /* for */
    
    if ( NoWorkers > 0 ) {				/* wait for sibling, if any */
	if ( leftworkers != 0 ) {
	    uAbsorb( LeftWorker, NULL, 0 );
	} /* if */
	uAbsorb( RightWorker, NULL, 0 );
    } /* if */
    uDie( NULL, 0 );
} /* Worker */

extern int atoi( char * );

void uMain( int argc, char *argv[] ) {
    int NoWorkers, NoProcessors, work;
    uTask worker;

    if ( argc != 4 ) {
        uError( "usage: no.-processors  no.-worker-tasks  amount-of-task-work\n" );
    } /* if */

    NoProcessors  = atoi( argv[1] );
    NoWorkers = atoi( argv[2] );
    work = atoi( argv[3] );
    
    uSetProcessors( NoProcessors );			/* create NoProcessors processors */

    worker = uEmit( Worker, NoWorkers, work / NoWorkers, work % NoWorkers );
    uAbsorb( worker, NULL, 0 );			

} /* uMain */

void uStart( void ) {
    /* uSetTimeSlice( 0 ); */
} /* uStart */

/* Local Variables: */
/* compile-command: "concc -Wall -O -nodebug -work -multi -o sim sim.c" */
/* End: */
