/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * uBench.c -- This program performs a benchmark test on the concurrency facilities
 *    of Encore Parallel Threads. It runs on a UMAX system.
 * 
 * Author           : Peter A. Buhr
 * Created On       : Tue Feb 13 11:06:19 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:25:00 1990
 * Update Count     : 35
 */

/*
  Timing result Encore Multimax 320 NS32332, 15Mhz:
  & N/A	& 858	& 54	& 250	& N/A		& N/A	\\
  */

#include <thread.h>
#include <stdio.h>
#include <Time.i>

void CoroutineCreateDelete( int N ) {
    printf( "& N/A" );
} /* CoroutineCreateDelete */

void TaskDummy( void ) {
} /* TaskDummy */

void TaskCreateDelete( int N ) {
    int StartTime, EndTime;
    int i;
    THREAD tid;

    StartTime = Time();

    for ( i = 0; i < N; i += 1 ) {
	tid = THREADcreate( TaskDummy, 0, 0, ATTACHED, 512, 1 );
	THREADjoin();
	THREADfree( tid );
    } /* for */

    EndTime = Time();
    printf( "\t& %d", ( EndTime - StartTime ) / N );
} /* TaskCreateDelete */

void CxtSwDummy( int *N ) {
    int i;

    for ( i = 0; i < *N; i += 1 ) {
	THREADreschedule();
    } /* for */
} /* CxtSwDummy */

void ContextSwitch( int N ) {
    int StartTime, EndTime;
    int i;

    THREADcreate( CxtSwDummy, &N, 4, ATTACHED, 512, 1 ); /* must have at least two tasks on the ready queue */

    StartTime = Time();

    for ( i = 0; i < N; i += 1 ) {
	THREADreschedule();
    } /* for */

    EndTime = Time();
    printf( "\t& %d", ( EndTime - StartTime ) / N / 2 ); /* divide by 2 because 2 context switches */
    
    THREADjoin();
} /* ContextSwitch */

struct PVdummy {
    int N;
    SEMAPHORE Shared1;
    SEMAPHORE Shared2;
};

void PVCxtSw2( struct PVdummy *dummy ) {
    int i;

    for ( i = 0; i < dummy->N; i += 1 ) {
	THREADvsem( dummy->Shared2 );
	THREADpsem( dummy->Shared1 );
    } /* for */
} /* PVCxtSw2 */

void PVCxtSw1( int *N ) {
    int StartTime, EndTime;
    struct PVdummy dummy;
    int i;

    dummy.N = *N;
    dummy.Shared1 = THREADseminit( 0 );
    dummy.Shared2 = THREADseminit( 0 );

    THREADcreate( PVCxtSw2, &dummy, 12, ATTACHED, 4*1024, 1 );
    
    StartTime = Time();

    for ( i = 0; i < *N; i += 1 ) {
	THREADpsem( dummy.Shared2 );
	THREADvsem( dummy.Shared1 );
    } /* for */

    EndTime = Time();
    printf( "\t& %d", ( EndTime - StartTime ) / *N / 2 ); /* divide by 2 because 2 P's */

    THREADjoin();
} /* PVCxtSw1 */

void Resume1( void ) {
    printf( "\t& N/A" );
} /* Resume1 */

void Send( int *N ) {
    printf( "\t\t& N/A" );
} /* Send */

void startup( void ) {
    const int NoOfTimes = 10000;

    CoroutineCreateDelete( NoOfTimes );

    TaskCreateDelete( NoOfTimes );

    ContextSwitch( NoOfTimes );

    THREADcreate( PVCxtSw1, &NoOfTimes, 4, ATTACHED, 4*1024, 1 );
    THREADjoin();

    Resume1();

    THREADcreate( Send, &NoOfTimes, 4, ATTACHED, 4*1024, 1 );
    THREADjoin();
} /* startup */

int main( int argc, char *argv[] ) {
    printf( "coroutine task\tcontext\tP/V,\tresume/resume,\tsend/rec/reply,\n" );
    printf( "create/\tcreate/\tswitch\tcxt\t16 bytes\t16 bytes\n" );
    printf( "delete\tdelete\t\tswitch\tbidirectional\tbidirectional\n" );

    THREADgo( 1, 1024*1024, startup, 0, 0, 4*1024, 2 );

    printf( "\t\\\\\n" );
} /* main */

/* Local Variables: */
/* compile-command: "gcc -O EncoreBench.c -lept" */
/* End: */
