# This is an OS specific configuration file
#	It assumes that OBJDIR, TARGET and DEBUG are previously defined.
#	It defines	CFLAGS, LDARGS, CPPFLAGS, STARTUPFILE, LDOBJS
#			PRINTER, PRINTFLAGS
#	It augments	SRC, OBJDIR, TARGET, CFLAGS, LDLIBS
#
PRINTER		= hw
PRINTFLAGS	= -P$(PRINTER)
STARTUPFILE	= $(OS)/startup.mk
CPPFLAGS 	= $(CFLAGS)
LDOBJS		= $(CSTARTUP) $(OBJDIR)/{$(<:f)}
LDARGS		= $(LDFLAGS) -o $@ $(LDOBJS) $(LDLIBS)

# Debug flags
DB_CFLAGS	= -g -DDBUG
DB_LDFLAGS	= -g
DB_LDLIBS	=

# NO Debug flags
NDB_CFLAGS	= -O
NDB_LDFLAGS	=
NDB_LDLIBS	=

# Local configuration modifications for CFLAGS.
CFLAGS         += -I$(OS)

# Sources that must be defined for each different version
OSSRC := arlib.c dirbrk.c explode.c rmprq.c ruletab.c
SRC  += $(OSSRC)
.SETDIR=$(OS) : $(OSSRC)

# Set source dirs so that we can find files named in this
# config file.
.SOURCE.h : $(OS)

# See if we modify anything in the lower levels.
.IF $(OSRELEASE) != $(NULL)
   .INCLUDE .IGNORE : $(OS)$(DIRSEPSTR)$(OSRELEASE)$(DIRSEPSTR)config.mk
.END

# Set the proper macros based on whether we are making the debugging version
# or not.
.IF $(DEBUG)
   CFLAGS	+= $(DB_CFLAGS)
   LDFLAGS	+= $(DB_LDFLAGS)
   LDLIBS	+= $(DB_LDLIBS)

   SILENT	:= $(.SILENT)
   .SILENT	:= yes
   TARGET	:= db$(TARGET)
   OBJDIR	:= $(OBJDIR).dbg
   .SILENT	:= $(SILENT)

    SRC		+= dbug.c malloc.c
    HDR		+= db.h 
    .SETDIR=common : dbug.c malloc.c
.ELSE
   CFLAGS	+= $(NDB_CFLAGS)
   LDFLAGS	+= $(NDB_LDFLAGS)
   LDLIBS	+= $(NDB_LDLIBS)
.END
