int dial()
{
/*
        this subroutine dials a hayes modem connected
        to the com port using calls to wrtbuf and rdbuf.

        if the first character in the dialing sequence (after
        the ATD) is M (or m), then "manual" dialing is assumed.
        in that case, just return and wait for received message.

        if echo is set to zero by the configuration file, then
        echoes are not expected from the modem.  if echo is not zero
        then echoes are expected and a fatal error exists if
        echoes are not received within the time out period.

        although this subroutine does not access the hardware
        directly it does depend on the method used.  this is because
        the non-bios version of the program is much faster than the
        bios version and some timeouts must therefore be different.
        also the non-bios version is fast enough to get think that the
        trailing digit or two of the telephone number are actually a
        modem response to the dialing
*/
#include "nbstime.h"
#include <stdio.h>
#ifdef IBMPC
#include <dos.h>
#endif
void wrtbuf(),wait();
int rdbuf();
char *ptr;
char ans[30],cc;
char ie1 = 'K';
char ie2 = '\n';
char ie3 = '\r';
char ie4 = 'Y';        /* response is BUSY */
char ie5 = 'T';        /* response is CONNECT */
char ie6 = 'R';        /* response is NO ANSWER or NO CARRIER */
char ie7 =  -120;
int j,k,kk,stat;
#ifdef IBMPC
#ifdef BIOS
int tmo  =  -3;     /* time-out limit, roughly 5 seconds */
int ttmo =  -40;    /* wait for number to be dialed */
#endif
#ifndef BIOS
int tmo  =  -15;    /* time-out limit, roughly 3 per second */
int ttmo = -400;    /* bigger number for non-bios use */
#endif
#endif
#ifdef SUN
int tmo = -10;
int ttmo= -200;     /* this is a LONG time-out. */
#endif
extern char number[30];
extern int echo;
extern int debug;
        if( (number[3] == 'm') || (number[3] == 'M') )
        {
        printf("\n Ready for manual dialing. Please dial now. \n enter")
;
        printf(" y <return> if connected, n <return> otherwise\n");
        scanf("%c",&cc);
        if( (cc == 'y') || (cc == 'Y')) return(1);
        return(0);
        }
        ptr="ATZ\r";
        wrtbuf(ptr);
        if( (rdbuf(ans,ie1,ie7,ie7,tmo) == 0) && (echo != 0) )
        {
        printf("\n No response from modem. -1\n");
        abort();
        }
        if( (rdbuf(ans,ie2,ie7,ie7,tmo) == 0) && (echo != 0) )
        {
        printf("\n No response from modem. -2\n");
        abort();
        }
        wait();
/*
        set: echo on, full duplex, speaker on, basic word responses on
*/
        ptr="AT E1 M1 Q0 V1\r";
        wrtbuf(ptr);
        if( (rdbuf(ans,ie1,ie7,ie7,tmo) == 0) && (echo !=0) )
        {
        printf("\n No response from modem. -3\n");
        abort();
        }
        wait();
        wrtbuf(number);
        if( (rdbuf(ans,ie3,ie7,ie7,tmo) == 0) && (echo !=0) )
        {
        printf("\n No response from modem. -4\n");
        abort();
        }
/*
	now wait for response from modem.  there are several
	possibilities as follows:
	1.  modem does not response at all.  this is almost
	    certainly an error -- flag immediately if echo
	    mode enabled. otherwise parse response.

	2.  read terminates on R from RINGING -- only some modems
	    can do this -- go back and read some more. do not
	    reset buffer pointer here since response is only
	    partial.

	3.  read terminates on R from NO ANSWER or NO CARRIER --
	    that's all folks.

	4.  read terminates on T from CONNECT -- the kind of 
	    stuff we like to see.

	5.  read terminates on T from AT or ATDT -- throw
	    it away and read some more.  this should only
	    happen on SUN machines where the reads are buffered
	    on IBMPC where the input port is not buffered the
	    ATDT string should have been overwritten by the
	    digits of the number.
	the variable stat is 0 until we are finished and is
	1 when the final modem status has been received
	kk points to the origin of the buffer for the current
	read.  it is zero unless a partial answer has been
	received (NO CAR for example).
*/
	stat=0;
	kk=0;
	do
	{
/*
	   read some stuff, abort if timeout and no response
	   (modem should have given status of call).

	   when rdbuf returns, k points to terminator relative to
	   origin which is kk.
*/
           if( (k=rdbuf(&ans[kk],ie4,ie5,ie6,ttmo)) == 0 )
              {
              printf("\n No response from modem. -5\n");
              abort();
              }
/*
	   if we read more than one character, and 
	   if end of message is ER, we have final modem status.
	   answer is either NO ANSWER or NO CARRIER. bad news 
	   either way but we are finished.
*/
           if( (k  > 1) && (ans[kk+k-1] == 'R') && (ans[kk+k-2] == 'E') )
	      stat=1;
/*
	   if we read more than one character and
	   if end of message is CT we have final modem status.
	   answer is CONNECT (possibly CONNECT 1200).
*/
	   if( (k > 1) && (ans[kk+k-1] == 'T') && (ans[kk+k-2] == 'C') )
	      stat=1;
/*
	   if we terminated on an R and it is the first character, then
	   it is the R of RINGING. if we read more than one character
	   and we ended with an R and the previous character was not E,
	   then we are in the midst of NO CARRIER  -- keep on reading.
*/
	   if( (kk+k > 1) && (ans[kk+k-1] == 'R') && (ans[kk+k-2] != 'E') )
	      kk += k;
	   if( (kk+k == 1) && (ans[0] == 'R') )
	      kk += k;
	} while (stat == 0);
/*
	since modem response was set to words, skip leading
	extraneous stuff including remnants of number and possible
	leading newline
*/
	for(j=0; ( (j < k+kk) && (ans[j] < 'A')) ; j++)  ;
        printf("\n modem answer= %s\n",&ans[j]);
        stat=0;
        for(k=j; (cc=ans[k]) != 0; k++) if(cc == 'T') stat=1;
        return(stat);
}
