/*------------------------------------------------------------------------

      File:  cmdPath.c
   Project:  Modules
   Created:  Tue Oct 22 23:45:57 1991
    Author:  John L. Furlani<john.furlani@East.Sun.COM>
  Revision:  1.4
  Last Mod:  20:04:22, 1/19/92

  Description of File:
		
	
	
	
	
	
	
	
------------------------------------------------------------------------*/
/***********************************************************************
* Copyright 1991 by John L. Furlani.  All rights reserved.
* 
* This material was written by John L. Furlani.
*
* Redistribution and use in source and binary forms are permitted
* provided that this entire copyright notice is duplicated in all such
* copies, and that any documentation, announcements, and other
* materials related to such distribution and use acknowledge that the
* software was developed by John Furlani.  No charge, other than an 
* "at-cost" distribution fee, may be charged for copies, derivations, 
* or distributions of this material without the express written 
* consent of the copyright holder.  The name of the author may not
* be used to endorse or promote products derived from this material 
* without specific prior written permission
*
* THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
* WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
* MERCHANTIBILITY AND FITNESS FOR ANY PARTICULAR PURPOSE.
************************************************************************/
static char SccsId[] = "@(#)cmdPath.c	1.4\t1/19/92";

#include <regexp.h>
#include "global.h"

int
cmdSetPath(ClientData client_data,
	       Tcl_Interp* interp,
	       int argc,
	       char* argv[])
{
  regexp* chkexpPtr;
  regexp* begexpPtr;
  regexp* midexpPtr;
  regexp* endexpPtr;
  char*   oldpath;
  char*   newpath;

  if(argc != 3) {
    Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		     " path-variable directory\"", (char *) NULL);
    return TCL_ERROR;
  }

  if(flags & M_REMOVE) { 
    return cmdRemovePath(client_data, interp, argc, argv);
  }

  if(flags & M_DISPLAY) {
    if(!strncmp(argv[0], "pre", 3)) {
      fprintf(stderr, "Prepend %s to %s\n", argv[2], argv[1]);
    } else {
      fprintf(stderr, "Append %s to %s\n", argv[2], argv[1]);
    }
    return TCL_OK;
  }
  
  if((oldpath = getenv(argv[1])) == NULL)
    oldpath = chk_nullvars(argv[1]);

  /* This code adds /usr/local/bin to PATH if it doesn't exist */

  /* I don't want this feature anymore!
  if(!strcmp(argv[1], "PATH") && strcmp(argv[2], "/usr/local/bin")) {
    chkexpPtr = 
      regcomp("(/usr/local/bin:)|(:/usr/local/bin)|(:/usr/local/bin:)");

    if(! regexec(chkexpPtr, oldpath)) {
      char* tmphold = argv[2];
      argv[2] = "/usr/local/bin";
      cmdSetPath(client_data, interp, argc, argv);
      argv[2] = tmphold;
      oldpath = getenv(argv[1]);
    }
  }
  */

  /* 
    Check to see if path is already in this path variable.

     It could be at the 
        beginning ... ^path:
	middle    ... :path:
	end       ... :path$
	only one  ... ^path$
   */
  newpath = (char*) malloc(4*(strlen(argv[2]) + 5));
  sprintf(newpath, "(^%s:)|(:%s:)|(:%s$)|(^%s$)", 
	  argv[2], argv[2], argv[2], argv[2]);
  chkexpPtr = regcomp(newpath);
  free(newpath);

  if(regexec(chkexpPtr, oldpath))
    return TCL_OK;

  /*
    Some space for our newly created path.
    We size at the oldpath plus the addition.
    */
  if((newpath = (char*) malloc(strlen(oldpath) 
			       + strlen(argv[2]) + 2)) == NULL) {
    Tcl_AppendResult(interp, "Couldn't malloc space for newpath.",
		     (char *) NULL);
    return TCL_ERROR;
  }

  strcpy(newpath, oldpath);

  if(! strcmp(oldpath, "")) {
    sprintf(newpath, "%s", argv[2]);
  } else {
    regexp* markexpPtr = regcomp(SWMARKER);

    if(regexec(markexpPtr, oldpath)) {
      if(!strcmp(argv[0], "prepend-path")) { /* Prepend to the path */
	char ch = *markexpPtr->endp[0];
	*markexpPtr->endp[0] = '\0';
	sprintf(newpath, "%s:%s", oldpath, argv[2]);
	*markexpPtr->endp[0] = ch;
	strcat(newpath, markexpPtr->endp[0]);
      } else {
	char ch = *markexpPtr->startp[0];
	*markexpPtr->startp[0] = '\0';
	sprintf(newpath, "%s:%s:", oldpath, argv[2]);
	*markexpPtr->startp[0] = ch;
	strcat(newpath, markexpPtr->startp[0]);
      }
    } else {
      if(!strcmp(argv[0], "prepend-path")) { /* Prepend to the path */
	sprintf(newpath, "%s:%s", argv[2], oldpath);
      } else {
	sprintf(newpath, "%s:%s", oldpath, argv[2]);
      }
    }
  }

  setenv(argv[1], newpath);  /* Must use Tcl's setenv */

  if(!(flags & (M_SWSTATE1 | M_SWSTATE2)))
    set_shell_variable(argv[1], newpath);

  free(newpath);
  return TCL_OK;
}


int
cmdRemovePath(ClientData client_data,
	      Tcl_Interp* interp,
	      int argc,
	      char* argv[])
{
  char* oldpath;
  char* tmppath;
  char  ch;
  int   start_offset, end_offset;
  regexp* regexpPtr  = (regexp*) 0;
  regexp* begexpPtr  = (regexp*) 0;
  regexp* midexpPtr  = (regexp*) 0;
  regexp* endexpPtr  = (regexp*) 0;
  regexp* onlyexpPtr = (regexp*) 0;
  regexp* markexpPtr = (regexp*) 0;
  char*   searchpath;

  if(argc > 3) {
    Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		     " path-variable directory\"", (char *) NULL);
    return TCL_ERROR;
  }

  if(flags & M_DISPLAY) {
    fprintf(stderr, "Removes %s from %s\n", argv[2], argv[1]);
    return TCL_OK;
  }

  if((tmppath = getenv(argv[1])) == NULL) {
    Tcl_AppendResult(interp, "getenv returned null -- ", argv[1], 
		     " variable not found", (char *) NULL);
    return TCL_OK;
  }    

  /*
    We want to make a local copy of old path because we're going
    to be butchering it and the environ one doesn't need to be
    changed in this manner.
    */
  oldpath = (char*) malloc(strlen(tmppath) + 1);
  strcpy(oldpath, tmppath);

  /*
    Now we need to find it in the path variable.  So, we create
    space enough to build search expressions.
    */
  searchpath = (char*)  malloc(strlen(argv[2]) + 3);

  /*
    For state3, we're looking to remove the marker.
    */
  if(flags & M_SWSTATE3) {
    argv[2] = SWMARKER;
  }

  /*
    This section searches for the oldpath in the PATH variable.
    There are four cases because the colons must be used as markers
    in order to guarantee that a partial match isn't being found.

    The start_offset and end_offset variables indicate how much to 
    cut or not to cut off of each end of the located
    string.  They differ for each case...beginning of
    the path, middle of the path, end of the path, 
    and for the only path.

    This is to ensure the colons get cut off properly.
    */
  sprintf(searchpath, "^%s:", argv[2]);
  begexpPtr = regcomp(searchpath);
    if(regexec(begexpPtr, oldpath)) {
      regexpPtr = begexpPtr;

      /*
	Copy from the beginning of the stringp[0] to one
	character before endp[0]
	*/
      start_offset = 0; end_offset = -1;
    } else {
      sprintf(searchpath, ":%s:", argv[2]);
      midexpPtr = regcomp(searchpath);
      if(regexec(midexpPtr, oldpath)) {
	regexpPtr = midexpPtr;

	/*
	  Copy from one character after stringp[0] to one
	  character before endp[0]
	*/
	start_offset = 1; end_offset = -1;
      } else {
	sprintf(searchpath, ":%s$", argv[2]);
	endexpPtr = regcomp(searchpath);
	if(regexec(endexpPtr, oldpath)) {
	  regexpPtr = endexpPtr;

	  /*
	    Copy from one character after stringp[0] 
	    through endp[0]
	    */
	  start_offset = 0; end_offset = 0;
	} else {
	  sprintf(searchpath, "^%s$", argv[2]);
	  onlyexpPtr = regcomp(searchpath);
	  if(regexec(onlyexpPtr, oldpath)) {
	    regexpPtr = onlyexpPtr;

	    /*
	      Copy from the beginning of stringp[0] 
	      through endp[0]
	    */
	    start_offset = 0; end_offset = 0;
	  }
	}
      }
    }

  free(searchpath);

  /*
    If I couldn't find it assume it wasn't there
    and return.
    */
  if(! regexpPtr) {
    return TCL_OK;
  }

  markexpPtr = regcomp(SWMARKER);

  /*
    In state1, we're actually replacing old paths with
    the markers for future appends and prepends.

    We only want to do this once to mark the location
    the module was formed around.
    */
  if((flags & M_SWSTATE1) && ! regexec(markexpPtr, oldpath)) {
    /*
      If I don't have enough space to replace the oldpath with the
      marker, then I must create space for the marker and thus
      recreate the PATH variable.
      */
    if((regexpPtr->endp[0] - regexpPtr->startp[0]) <= strlen(SWMARKER)) {
      char* newenv;
      
      newenv = (char*) malloc(((regexpPtr->startp[0] + start_offset) -
			       oldpath) +
			      strlen(SWMARKER) +
			      strlen(argv[1]) +
			      strlen(regexpPtr->endp[0]) + end_offset + 1);

      *(regexpPtr->startp[0] + start_offset) = '\0';
      
      sprintf(newenv, "%s%s%s", 
	      oldpath, SWMARKER, regexpPtr->endp[0] + end_offset);

      setenv(argv[1], newenv);
    } else {
      /* 
	We have enough space to put the MARKER in where the old
	path was so we'll just use that space.

	I leave some memory off at the end of the path in this
	case and this could be considered a memory leak of sorts.
	*/
      strcpy(oldpath + ((regexpPtr->startp[0] + start_offset) - oldpath), 
	     SWMARKER);
      strcpy(oldpath + 
	     ((regexpPtr->startp[0] + start_offset) - oldpath) +
	     strlen(SWMARKER),
	     oldpath + ((regexpPtr->endp[0] + end_offset) - oldpath));
      strcpy(tmppath, oldpath);	/* On remove -- will always be <= before */
    }
  } else {
    /*
      We must be in SW_STATE3 or not in SW_STATE at all.
      Removing the marker should be just like removing any other path.
      */
    strcpy(oldpath + ((regexpPtr->startp[0] + start_offset) - oldpath), 
	   oldpath + ((regexpPtr->endp[0]) - oldpath));
    strcpy(tmppath, oldpath);	/* On remove -- will always be <= before */
  }

  if(! (flags & M_SWSTATE1)) {
    setenv(argv[1], oldpath);  /* Must use Tcl's setenv */

    if(!(flags & (M_SWSTATE1 | M_SWSTATE2)))
      set_shell_variable(argv[1], oldpath);
  }

  return TCL_OK;
}

char*
chk_nullvars(char* varname)
{
  if(!strcmp(varname, "MANPATH"))
    return "/usr/man";

  if(!strcmp(varname, "LD_LIBRARY_PATH"))
    return "/usr/lib";

  return "";
}
