(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Mon Dec 30 09:33:31 PST 1991 by kalsow         *)
(*      modified on Thu Nov  2 21:55:24 1989 by muller         *)

(*      modified on Sun May  7 15:35:59 1989 by stolfi         *)

INTERFACE Refany;

(* Some standard operations on REFANY.

   This package defines some standard types and operations
   on REFANY.  When (if) Modula-3 has generics, this interface
   will be useful.

   Index: refanys, exported
*)

TYPE T = REFANY;

PROCEDURE New (value: T): REF T;
(* Allocates and initializes a new heap value *)

PROCEDURE NewArray (size: CARDINAL;  value: T := NIL): REF ARRAY OF T;
(* Allocates a new array from the heap
  and initializes all its elements with the given value *)

PROCEDURE Compare (a, b: T): INTEGER;
(* == RETURN (a - b) *)

PROCEDURE Lt (a, b: T): BOOLEAN;
(* == RETURN (a < b) *)

PROCEDURE Eq (a, b: T): BOOLEAN;
(* == RETURN (a = b) *)

(**************************************************************************
  The implementation of Hash in the presence of a copying collector was
  safe but unsound since it simply loopholed the value to an integer.  - WKK

PROCEDURE Hash (a: T): INTEGER;
(* returns a suitable hash value *)
********************************************************************)

END Refany.
