(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Jun 16 10:16:13 PDT 1992 by muller                   *)
(*      modified on Tue Nov 26 18:15:36 PST 1991 by meehan                   *)

INTERFACE SeekableRd;

IMPORT Rd, Thread;

TYPE
  Public = Rd.T OBJECT
           METHODS
             init (rd: Rd.T; closeChild := FALSE; bufferSizeFactor := 4): T
                   RAISES {Rd.EndOfFile, Rd.Failure, Thread.Alerted}
           END;

  T <: Public;

(* 
   NEW (T).init (closeChild, bufferSizeFactor)

   returns a seekable reader. If rd is already seekable, then it
   returns a TransparentRd.T (i.e., a transparent filter). Otherwise, we
   create a new reader with a buffer whose size is 'bufferSizeFactor' times
   the size of rd's buffer.

   Calling Rd.Close on a seekable reader does not close rd unless
   closeChild is true.

   In order to determine the size of rd's buffer, we have to do a seek on
   rd. This may block. That's why the init method can raise exceptions.

   This interface is designed for making intermittent readers (e.g., stdin
   and pipes) seekable.

   *)

PROCEDURE EnsureSeekable (rd: Rd.T; closeChild: BOOLEAN := FALSE): Rd.T
  RAISES {Rd.EndOfFile, Rd.Failure, Thread.Alerted};
(* This creates a new reader, a filter for rd, that is guaranteed to be
   seekable. If rd is already seekable, then this returns a
   TransparentRd.T.  Otherwise it returns a SeekableRd.T. *)

END SeekableRd.




