(* Copyright (C) 1990, Digital Equipment Corporation.         *)
(* All rights reserved.                                       *)
(* See the file COPYRIGHT for a full description.             *)

INTERFACE PklRep;

(* Internal pickle structures *)

(* Pickle file format:

    Pickle = "PPkl" version Header {Object} {Special} {Type} {Proc}.
    Header = nofobjects objectssize nofspecs specssize
             noftypes nofprocs rootindex.
    Object = localtc {dimsize} {byte}.
    Special = localtc datasize {byte}.
    Type = Fingerprint.
    Proc = Fingerprint.
    Fingerprint = {integer}.

  All lower-case identifier represent an integer whose coding in 
  the file is dependent on the endianess of the machine used (an 
  integer is loopholed as a fixed array of char of length 
  BYTESIZE(INTEGER)).

  An "Object" is the memory image of an object with following 
  modifications: the typecode is replaced by a local typecode "localtc" 
  indexing the fingerprints in "Type"; a reference to another object 
  is replaced by the number of this object (FirstObj being the number 
  of the first object); a reference to a "Special" object (see below) 
  is replaced by the number of this special (the constant FirstSpec 
  being the number of the first special); a procedure address being 
  replaced by the number of the procedure (FirstProc being the number 
  of the first procedure).
  
  A "Special" is the output of a user-defined WriteBytesProc for 
  a given type applied to an object of that type whose local typecode 
  in the file is "localtc".

  Sizes are expressed in bytes.

  A "Fingerprint" is a series of integers provided by and returned
  to the runtime system to identify types or procedures. This program
  works independently on the length of fingerprints.

*)

IMPORT Pkl, RTType;

CONST
  Version   = 1; (* program version number written in the pickle file *)
  FirstObj  = 1; (* must be > NIL *)
  FirstProc = 1; (* must be > NIL *)
  FirstSpec = 16_40000000;

TYPE
  ConvertList = REF RECORD
    tc   : RTType.Typecode;
    next : ConvertList
  END ;

  Procs = REF ARRAY OF RECORD
    first   : ConvertList        := NIL;
    wrconv  : Pkl.ConvertProc    := NIL;
    rdconv  : Pkl.ConvertProc    := NIL;
    wrbytes : Pkl.WriteBytesProc := NIL;
    rdbytes : Pkl.ReadBytesProc  := NIL
  END ;

  Integer = ARRAY [0..BYTESIZE(INTEGER)-1] OF CHAR;

  ToChars = REF ARRAY [0..100000000] OF CHAR;

VAR procs: Procs := NIL;

PROCEDURE Init ();

END PklRep.


