(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Sat Jan 20 01:37:42 1990 by muller *)
(*      modified on Fri Jan 19 09:26:47 1990 by kalsow *)


INTERFACE Poly;

(* This module provides polynomials of degree [0..63] with
    coefficients in the field Z(2).
*)

TYPE
  T = ARRAY [0..1] OF INTEGER;

CONST
  ZERO = T{ 0, 0 };
  ONE  = T{ 0, FIRST (INTEGER) };
  X    = T{ 0, 16_40000000 };

PROCEDURE Sum     (p, q: T) : T;     (* returns (p+q) *)
PROCEDURE Product (p, q: T) : T;     (* returns (p * q MOD PolyBasis.P) *)
PROCEDURE TimesX  (p : T)   : T;     (* returns (p * X^1) *)
PROCEDURE Power   (d: CARDINAL) : T; (* returns (x^d MOD PolyBasis.P) *)

PROCEDURE ComputeMod (READONLY source: ARRAY OF INTEGER; init: T) : T;
  (* This procedure assumes that source defines a polynomial,
     A(x), of degree (32*NUMBER(source)).
     The procedure returns (T*x^(32*NUMBER(source)) + A(x)) MOD PolyBasis.P *)

END Poly.
