(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: ETimer.i3                                             *)
(* Last modified on Wed Jul 15 07:50:54 PDT 1992 by kalsow     *)

(* This interface provides a set of non-overlapping timers.
   The timers record elapsed time, not CPU time.

   A background timer and a garbage collection timer are
   automatically provided.

   The stack of suspended timers can contain at most 100 timers.
*)

INTERFACE ETimer;

IMPORT Wr;

TYPE T <: REFANY;

PROCEDURE New (label: TEXT): T;
(* create a new timer *)

PROCEDURE Push (t: T);
(* suspend the currently running timer, start t *)

PROCEDURE Pop ();
(* suspend the currently running timer, resume the previous one. *)

PROCEDURE Dump (wr: Wr.T);
(* dump the non-zero timers to wr.  Note, the timers will be dumped
   in the reverse order of how they were created.  *)

PROCEDURE Elapsed (t: T): LONGREAL;
(* returns the seconds accumulated by t. *)

PROCEDURE TotalElapsed (): LONGREAL;
(* returns the total elpased seconds *)

PROCEDURE Enable ();
(* start the timers.  Note that Enable must be called at
   least once before any timers will begin accumulating time.  *)

PROCEDURE Reset (t: T);
(* reset t's accumulator to zero. *)

PROCEDURE ResetAll ();
(* reset all timers to zero. *)

END ETimer.
