(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Created by stolfi on Tue Nov  8 18:06:42 1988               *)
(* Last modified on Tue Feb 11 21:42:17 PST 1992 by muller     *)
(*      modified on Wed Nov 20 19:31:37 PST 1991 by stolfi     *)
(*      modified on Tue Feb 27 00:04:04 1990 by harrison       *)

MODULE CIETest EXPORTS Main;

IMPORT Color, Fmt, RGB, CIE, Wr, Rd, Thread;
FROM Stdio IMPORT stderr;

PROCEDURE Main () =
  <* FATAL Wr.Failure, Rd.Failure, Thread.Alerted *>
  BEGIN
    TestColor ("Black",   RGB.T{0.000, 0.000, 0.000});
    TestColor ("White",   RGB.T{1.000, 1.000, 1.000});
    TestColor ("Grey",    RGB.T{0.500, 0.500, 0.500});
    TestColor ("DimGrey", RGB.T{0.329, 0.329, 0.329});
    TestColor ("Red",     RGB.T{1.000, 0.000, 0.000});
    TestColor ("Green",   RGB.T{0.000, 1.000, 0.000});
    TestColor ("Blue",    RGB.T{0.000, 0.000, 1.000});
    Wr.Close(stderr);
  END Main;

PROCEDURE TestColor (name: TEXT; rgb: RGB.T) =
  VAR XYZ, XYZq: CIE.XYZ; 
      Yxy: CIE.Yxy; 
      Yuv: CIE.Yuv; 
      rgbq: RGB.T;
  <* FATAL Wr.Failure, Rd.Failure, Thread.Alerted *>
  BEGIN
    Wr.PutText (stderr, "\n");
    Wr.PutText (stderr, "Testing color " & name & " = ");
    PrintColor (stderr, rgb, "RGB");
    Wr.PutText (stderr, "...\n");
    XYZ := CIE.XYZFromRGB (rgb);
    rgbq := CIE.RGBFromXYZ (XYZ);
    TestMap ("RGB", "XYZ", rgb, XYZ, rgbq);
    Yxy := CIE.YxyFromXYZ (XYZ);
    XYZq := CIE.XYZFromYxy (Yxy);
    TestMap ("XYZ", "Yxy", XYZ, Yxy, XYZq);
    Yuv := CIE.YuvFromXYZ (XYZ);
    XYZq := CIE.XYZFromYuv (Yuv);
    TestMap ("XYZ", "Yuv", XYZ, Yuv, XYZq);

  END TestColor;

PROCEDURE PrintColor (wr: Wr.T; c: Color.T; sys: TEXT) =
  <* FATAL Wr.Failure, Rd.Failure, Thread.Alerted *>
  BEGIN
    Wr.PutText (wr, "(" 
      & Fmt.Pad (Fmt.Real (c[0], 4, Fmt.Style.Flo), 7)
      & " " & Fmt.Pad (Fmt.Real (c[1], 4, Fmt.Style.Flo), 7)
      & " " & Fmt.Pad (Fmt.Real (c[2], 4, Fmt.Style.Flo), 7)
      & ") [" & sys & "]")
  END PrintColor;

PROCEDURE TestMap (sysa, sysb: TEXT; a, b, aq: Color.T) =
  <* FATAL Wr.Failure, Rd.Failure, Thread.Alerted *>
  BEGIN
    Wr.PutText (stderr, "Original:   ");
    PrintColor (stderr, a, sysa);
    Wr.PutText (stderr, "\n");
    Wr.PutText (stderr, sysb & "From" & sysa & ": ");
    PrintColor (stderr, b, sysb);
    Wr.PutText (stderr, "\n");
    Wr.PutText (stderr, sysa & "From" & sysb & ": ");
    PrintColor (stderr, aq, sysa);
    Wr.PutText (stderr, "\n");
    Wr.PutText (stderr, "Error = "
      & Fmt.Pad (Fmt.Real (RelDist (a, aq, 1.0e-06), 3, Fmt.Style.Sci), 9) 
      & "\n"
    );
  END TestMap;

PROCEDURE RelDist(READONLY x, y: Color.T; eps: REAL := 1.0e-37): REAL = 
  VAR u, v: REAL;
      s, m: REAL;
  BEGIN
    s := 0.0;
    FOR i := 0 TO 2 DO
      u := x[i]; v := y[i];
      m := MAX(MAX(ABS(u), ABS(v)), eps);
      s := MAX(ABS(u/m - v/m) - eps/m, s);
    END;
    RETURN s
  END RelDist;

BEGIN
  Main ();
END CIETest.

